/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.export;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.AnypointException;
import com.aeontronix.anypointsdk.exchange.ExchangeClient;
import com.aeontronix.anypointsdk.exchange.ExchangeClientApplication;
import com.aeontronix.anypointsdk.organization.Environment;
import com.aeontronix.anypointsdk.organization.Organization;
import com.aeontronix.anypointsdk.organization.OrganizationData;
import com.aeontronix.restclient.RESTException;
import org.slf4j.Logger;

import java.io.IOException;
import java.util.ArrayList;

import static org.slf4j.LoggerFactory.getLogger;

public class OrgExport {
    private static final Logger logger = getLogger(OrgExport.class);
    private OrganizationData data;
    private ArrayList<EnvExport> envs = new ArrayList<>();
    private ArrayList<ClientAppExport> clientApps = new ArrayList<>();

    public OrgExport() {
    }

    public OrgExport(ExportFilters filters, boolean downloadApps, AnypointClient client, Organization organization) throws RESTException, IOException, AnypointException {
        data = organization.getData();
        for (Environment environment : organization.findEnvironments()) {
            if (filters.processEnv(environment)) {
                envs.add(new EnvExport(filters, downloadApps, client, environment));
            } else {
                logger.info("Skipping environment " + environment.getName());
            }
        }
        ExchangeClient exchangeClient = client.getExchangeClient();
        for (ExchangeClientApplication appOverview : exchangeClient.listClientApplications(organization.getId())) {
            ExchangeClientApplication cApp = exchangeClient.findClientApplicationById(organization.getId(), Integer.toString(appOverview.getData().getId()));
            clientApps.add(new ClientAppExport(cApp.getData()));
        }
    }

    public OrganizationData getData() {
        return data;
    }

    public void setData(OrganizationData data) {
        this.data = data;
    }

    public ArrayList<EnvExport> getEnvs() {
        return envs;
    }

    public void setEnvs(ArrayList<EnvExport> envs) {
        this.envs = envs;
    }

    public ArrayList<ClientAppExport> getClientApps() {
        return clientApps;
    }

    public void setClientApps(ArrayList<ClientAppExport> clientApps) {
        this.clientApps = clientApps;
    }

    public void doImport(ExportFilters filters, AnypointClient client) throws RESTException, IOException {
        for (EnvExport env : envs) {
            env.doImport(filters, client);
        }
    }
}
