package com.aeontronix.anypointsdk.monitoring;

import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.File;
import java.math.BigDecimal;
import java.util.List;

public class MetricsQueryResponse {
    private List<MetricsResult> results;

    public List<MetricsResult> getResults() {
        return results;
    }

    public void setResults(List<MetricsResult> results) {
        this.results = results;
    }

    public static void main(String[] args) throws Exception {
        final MetricsQueryResponse resp = new ObjectMapper().readValue(new File("/Users/yannick/Projects/aeontronix/enhanced-mule/anypoint-sdk/notes/latency-response-sample-data.json"),
                MetricsQueryResponse.class);
        BigDecimal max = BigDecimal.ZERO;
        for (MetricsResult result : resp.getResults()) {
            for (MetricsSeries series : result.getSeries()) {
                for (String[] values : series.getValues()) {
                    final String v = values[1];
                    if (v != null) {
                        final BigDecimal val = new BigDecimal(v);
                        if (val.compareTo(max) > 0) {
                            max = val;
                        }
                    }
                }
            }
        }
        System.out.println(max);
    }
}
