package com.aeontronix.anypointsdk.monitoring;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.restclient.RESTClientHost;
import com.aeontronix.restclient.RESTException;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Map;

public class MonitoringClient {
    private final RESTClientHost restClient;
    private AnypointClient anypointClient;

    public MonitoringClient(AnypointClient anypointClient) {
        this.anypointClient = anypointClient;
        restClient = anypointClient.getAnypointRestClient();
    }

    public MetricsQueryResponse getApplicationMetrics(MetricsType metricsType, String orgId, String envId, String appId, LocalDateTime from, LocalDateTime to) throws RESTException {
        final ZoneId systemZoneId = ZoneId.systemDefault();
        final long fromEpoch = from.toInstant(ZoneOffset.from(ZoneOffset.UTC)).toEpochMilli();
        final long toEpoch = to.toInstant(ZoneOffset.from(ZoneOffset.UTC)).toEpochMilli();
        final String queryStr = "SELECT " + metricsType.getSelect() + " WHERE (\"org_id\" = '" + orgId +
                "' AND \"env_id\" = '" + envId + "' AND \"app_id\" = '" + appId +
                "') AND time >= " + fromEpoch + "ms and time <= " + toEpoch + "ms GROUP BY time(1m) " + metricsType.getBy() +
                " fill(linear) tz('" + systemZoneId + "')";
        return queryApplicationMetrics(queryStr);
    }

    @SuppressWarnings("unchecked")
    public MetricsQueryResponse queryApplicationMetrics(String query) throws RESTException {
        String database;
        String url;
        try {
            final Map<String, Map<String, Map<String, Map<String, String>>>> bootData = restClient.get("monitoring/api/visualizer/api/bootdata", Map.class);
            final Map<String, String> influx = bootData.get("Settings").get("datasources").get("influxdb");
            database = influx.get("database");
            url = influx.get("url");
        } catch (NullPointerException e) {
            throw new UnexpectedException("Invalid boot data (it might be anypoint changed how graphs load in which case this logic needs updating)", e);
        }
        return restClient.get().path("monitoring/api/visualizer/").path(url).path("query")
                .queryParam("db", database).queryParam("q", query).queryParam("epoch", "ms").build()
                .executeAndConvertToObject(MetricsQueryResponse.class);
    }
}
