package com.aeontronix.anypointsdk.organization;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.restclient.RESTException;

import java.util.List;

public class Organization {
    private AnypointClient client;
    private OrganizationData data;

    public Organization(AnypointClient client, OrganizationData data) {
        this.client = client;
        this.data = data;
    }

    public OrganizationData getData() {
        return data;
    }

    public boolean isIsAutomaticAdminPromotionExempt() {
        return data.isIsAutomaticAdminPromotionExempt();
    }

    public List<String> getSubOrganizationIds() {
        return data.getSubOrganizationIds();
    }

    public String getClientId() {
        return data.getClientId();
    }

    public boolean isIsRoot() {
        return data.isIsRoot();
    }

    public SubscriptionData getSubscription() {
        return data.getSubscription();
    }

    public String getOwnerId() {
        return data.getOwnerId();
    }

    public boolean isIsFederated() {
        return data.isIsFederated();
    }

    public String getCreatedAt() {
        return data.getCreatedAt();
    }

    public String getOrgType() {
        return data.getOrgType();
    }

    public Object getParentName() {
        return data.getParentName();
    }

    public boolean isIsMaster() {
        return data.isIsMaster();
    }

    public String getDomain() {
        return data.getDomain();
    }

    public String getName() {
        return data.getName();
    }

    public String getId() {
        return data.getId();
    }

    public String getMfaRequired() {
        return data.getMfaRequired();
    }

    public String getIdproviderId() {
        return data.getIdproviderId();
    }

    public String getUpdatedAt() {
        return data.getUpdatedAt();
    }

    public List<Environment> findEnvironments() throws RESTException {
        return client.findEnvironments(data.getId());
    }
}
