/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.amc;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.amc.AMCAppDeploymentParameters;
import com.aeontronix.anypointsdk.amc.AMCApplicationListResponse;
import com.aeontronix.anypointsdk.amc.AMCDeploymentResponse;
import com.aeontronix.anypointsdk.amc.application.ApplicationIdentifier;
import com.aeontronix.anypointsdk.amc.application.ApplicationSource;
import com.aeontronix.anypointsdk.amc.application.FileApplicationSource;
import com.aeontronix.anypointsdk.amc.application.deployment.ApplicationDeployment;
import com.aeontronix.anypointsdk.amc.application.deployment.ApplicationDeploymentData;
import com.aeontronix.anypointsdk.util.SecurityHelper;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.restclient.RESTClientHost;
import com.aeontronix.restclient.RESTClientHostPathBuilder;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.errorhandling.RESTAuthorizationException;
import com.aeontronix.restclient.errorhandling.RESTSecurityException;
import com.aeontronix.restclient.json.JsonConvertionException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMCClient {
    private static final Logger logger = LoggerFactory.getLogger(AMCClient.class);
    private RESTClientHost restClient;
    private AnypointClient anypointClient;

    public AMCClient(AnypointClient anypointClient) {
        this.restClient = anypointClient.getAnypointRestClient();
        this.anypointClient = anypointClient;
    }

    public List<ApplicationDeploymentData> listDeployments(String orgId, String envId) throws RESTException {
        try {
            return ((AMCApplicationListResponse)AMCClient.deploymentPath(this.restClient.get(), orgId, envId).build().executeAndConvertToObject(AMCApplicationListResponse.class)).getItems();
        }
        catch (RESTException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<ApplicationDeploymentData> findDeploymentByName(String orgId, String envId, String name) throws RESTException {
        return this.listDeployments(orgId, envId).stream().filter(a -> a.getName().equals(name)).findFirst();
    }

    public ApplicationDeployment findDeploymentById(String orgId, String envId, String appId) throws RESTException {
        try {
            return new ApplicationDeployment((ApplicationDeploymentData)AMCClient.deploymentPath(this.restClient.get(), orgId, envId).pathEl(new String[]{appId}).build().executeAndConvertToObject(ApplicationDeploymentData.class));
        }
        catch (RESTAuthorizationException e) {
            throw SecurityHelper.authorizationFailed(this.anypointClient, (RESTSecurityException)e, "Failed to list AMC deployments in org " + orgId + ", env " + envId, "Runtime Manager > Read Runtime Fabrics");
        }
    }

    public AMCDeploymentResponse deployApplication(AMCAppDeploymentParameters params, String appName, String orgId, String envId, String target, ApplicationSource applicationSource, Map<String, String> properties, Set<String> securePropertiesKeys, String buildNumber, boolean force) throws RESTException, IOException {
        try {
            RESTClientHostPathBuilder method;
            ApplicationIdentifier appId = applicationSource.getApplicationIdentifier();
            if (params.getAssetOrgId() != null) {
                appId.setGroupId(orgId);
            } else if (!this.anypointClient.findOrganization(appId.getGroupId()).isPresent()) {
                logger.debug("Application group id {} doesn't match any organization, replacing it with target org id {}", (Object)appId.getGroupId(), (Object)orgId);
                appId.setGroupId(orgId);
            }
            if (params.getAssetArtifactId() != null) {
                appId.setArtifactId(params.getAssetArtifactId());
            }
            if (params.getAssetVersion() != null) {
                appId.setVersion(params.getAssetVersion());
            }
            if (appId.getVersion().toLowerCase().endsWith("-snapshot")) {
                appId.setVersion(appId.getVersion() + "-" + (buildNumber != null ? buildNumber : DateTimeFormatter.ofPattern("yyyyMMddHHmmssSS").format(LocalDateTime.now())));
            }
            if (applicationSource instanceof FileApplicationSource) {
                block18: {
                    logger.info("Publishing archive to exchange: " + appId);
                    try {
                        this.anypointClient.getExchangeClient().createAsset(orgId, appId.getArtifactId(), appId.getVersion(), appName).file("jar", "mule-application", null, applicationSource.getFilename(), applicationSource.getFile()).execute().close();
                    }
                    catch (RESTException e) {
                        if (e.getStatusCode() != 409 || !force) break block18;
                        String oldVersion = appId.getVersion();
                        appId.setVersion(oldVersion + "-" + DateTimeFormatter.ofPattern("yyyyMMddHHmmssSS").format(LocalDateTime.now()));
                        logger.warn("Unable to publish application using version {} because it is already in use. Since force deploy is enabled changing version to {}", (Object)oldVersion, (Object)appId.getVersion());
                        this.anypointClient.getExchangeClient().createAsset(orgId, appId.getArtifactId(), appId.getVersion(), appName).file("jar", "mule-application", null, applicationSource.getFilename(), applicationSource.getFile()).execute().close();
                    }
                }
                logger.info("Finished publishing archive to exchange: " + appId);
            }
            if (params.getRuntimeVersion() == null) {
                params.setRuntimeVersion(this.anypointClient.getCloudhubClient().findDefaultCHMuleVersion().getVersion());
            }
            Optional<ApplicationDeploymentData> existing = this.findDeploymentByName(orgId, envId, appName);
            HashMap<String, String> insecureProperties = new HashMap<String, String>();
            HashMap<String, String> secureProperties = new HashMap<String, String>();
            if (existing.isPresent()) {
                String deploymentId = existing.get().getId();
                Iterator<Map.Entry<String, String>> existingDeployment = this.findDeploymentById(orgId, envId, deploymentId);
                insecureProperties.putAll(((ApplicationDeployment)((Object)existingDeployment)).getData().getNonSecureProperties());
                secureProperties.putAll(((ApplicationDeployment)((Object)existingDeployment)).getData().getSecureProperties());
                Map<String, String> existingLogLevels = ((ApplicationDeployment)((Object)existingDeployment)).getLoggingLevels();
                Map<String, String> newLogLevels = params.getLogLevels(true);
                for (Map.Entry<String, String> e : existingLogLevels.entrySet()) {
                    newLogLevels.computeIfAbsent(e.getKey(), k -> (String)e.getValue());
                }
                params.setLogLevels(newLogLevels);
                method = AMCClient.deploymentPath(this.restClient.patch(), orgId, envId).pathEl(new String[]{deploymentId});
            } else {
                method = AMCClient.deploymentPath(this.restClient.post(), orgId, envId);
            }
            HashSet existingInsecureKeys = new HashSet(insecureProperties.keySet());
            for (String existingInsecureKey : existingInsecureKeys) {
                if (!securePropertiesKeys.contains(existingInsecureKey)) continue;
                secureProperties.put(existingInsecureKey, (String)insecureProperties.remove(existingInsecureKey));
            }
            for (Map.Entry<String, String> e : properties.entrySet()) {
                String key = e.getKey();
                if (!securePropertiesKeys.contains(key) && !secureProperties.containsKey(key)) {
                    insecureProperties.put(key, e.getValue());
                    continue;
                }
                secureProperties.put(key, e.getValue());
            }
            ApplicationDeploymentData applicationData = params.toDataObject(appName, target, appId, insecureProperties, secureProperties);
            ApplicationDeploymentData response = (ApplicationDeploymentData)method.build().jsonBody((Object)applicationData).executeAndConvertToObject(ApplicationDeploymentData.class);
            return new AMCDeploymentResponse(this, orgId, envId, new ApplicationDeployment(response));
        }
        catch (JsonConvertionException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    private static RESTClientHostPathBuilder deploymentPath(RESTClientHostPathBuilder builder, String orgId, String envId) {
        return builder.path("/amc/application-manager/api/v2/organizations/").pathEl(new String[]{orgId}).path("/environments/").pathEl(new String[]{envId}).path("/deployments");
    }
}

