/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.amc;

import com.aeontronix.anypointsdk.amc.AMCClient;
import com.aeontronix.anypointsdk.amc.AMCDeploymentFailedException;
import com.aeontronix.anypointsdk.amc.application.DeploymentResponse;
import com.aeontronix.anypointsdk.amc.application.deployment.ApplicationDeployment;
import com.aeontronix.anypointsdk.amc.application.deployment.ApplicationDeploymentData;
import com.aeontronix.anypointsdk.amc.application.deployment.Replica;
import com.aeontronix.restclient.RESTException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMCDeploymentResponse
extends DeploymentResponse {
    private static final Logger logger = LoggerFactory.getLogger(AMCDeploymentResponse.class);
    private AMCClient AMCClient;
    private String orgId;
    private String envId;
    private ApplicationDeployment deployment;

    public AMCDeploymentResponse(AMCClient AMCClient2, String orgId, String envId, ApplicationDeployment deployment) {
        this.AMCClient = AMCClient2;
        this.orgId = orgId;
        this.envId = envId;
        this.deployment = deployment;
    }

    public ApplicationDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    public boolean checkDeploymentComplete() throws AMCDeploymentFailedException, RESTException {
        logger.debug("Checking deployment");
        ApplicationDeploymentData deploymentData = this.deployment.getData();
        this.deployment = this.AMCClient.findDeploymentById(this.orgId, this.envId, deploymentData.getId());
        String desiredVersion = deploymentData.getDesiredVersion();
        logger.debug("Desired version is {}", (Object)desiredVersion);
        for (Replica replica : deploymentData.getReplicas()) {
            String replicaVersion = replica.getCurrentDeploymentVersion();
            logger.debug("Replica version is {}", (Object)replicaVersion);
            if (replicaVersion.equals(desiredVersion)) continue;
            logger.debug("Version is not desired one yet");
            return false;
        }
        String status = deploymentData.getApplicationState().getStatus();
        logger.debug("Deployment status is {}", (Object)status);
        return "RUNNING".equals(status);
    }
}

