/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.amc.application;

import com.aeontronix.anypointsdk.amc.application.ApplicationIdentifier;
import com.aeontronix.anypointsdk.amc.application.ApplicationSource;
import com.aeontronix.commons.exception.UnexpectedException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileApplicationSource
extends ApplicationSource {
    private static final Logger logger = LoggerFactory.getLogger(FileApplicationSource.class);
    private File file;

    public FileApplicationSource(File file) {
        block8: {
            this.file = file;
            try {
                ZipFile zipFile = new ZipFile(file);
                ZipEntry artJson = zipFile.getEntry("META-INF/mule-artifact/classloader-model.json");
                if (artJson == null) break block8;
                try (InputStream is = zipFile.getInputStream(artJson);){
                    ObjectNode jsonNode = (ObjectNode)new ObjectMapper().readTree(is);
                    JsonNode artifactCoordinates = jsonNode.get("artifactCoordinates");
                    JsonNode groupId = artifactCoordinates.get("groupId");
                    JsonNode artifactId = artifactCoordinates.get("artifactId");
                    JsonNode version = artifactCoordinates.get("version");
                    this.applicationIdentifier = new ApplicationIdentifier(groupId.asText(), artifactId.asText(), version.asText());
                    logger.debug("Loaded ApplicationIdentifier from archive: " + this.applicationIdentifier);
                }
            }
            catch (IOException e) {
                throw new UnexpectedException((Throwable)e);
            }
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getFilename() {
        return this.file.getName();
    }
}

