/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.amc.application.deployment;

import com.aeontronix.anypointsdk.amc.application.deployment.ApplicationPropertiesService;
import com.aeontronix.anypointsdk.amc.application.deployment.ApplicationServices;
import com.aeontronix.anypointsdk.amc.application.deployment.ApplicationState;
import com.aeontronix.anypointsdk.amc.application.deployment.Replica;
import com.aeontronix.anypointsdk.amc.application.deployment.Target;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ApplicationDeploymentData {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="application")
    private ApplicationState applicationState;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="labels")
    private List<String> labels;
    @JsonProperty(value="target")
    private Target target;
    @JsonProperty(value="lastSuccessfulVersion")
    private String lastSuccessfulVersion;
    @JsonProperty(value="desiredVersion")
    private String desiredVersion;
    @JsonProperty(value="creationDate")
    private Long creationDate;
    @JsonProperty(value="lastModifiedDate")
    private Long lastModifiedDate;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="replicas")
    private List<Replica> replicas;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ApplicationState getApplicationState(boolean create) {
        if (this.applicationState == null && create) {
            this.applicationState = new ApplicationState();
        }
        return this.applicationState;
    }

    public ApplicationState getApplicationState() {
        return this.applicationState;
    }

    public void setApplicationState(ApplicationState applicationState) {
        this.applicationState = applicationState;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public Long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getLastSuccessfulVersion() {
        return this.lastSuccessfulVersion;
    }

    public void setLastSuccessfulVersion(String lastSuccessfulVersion) {
        this.lastSuccessfulVersion = lastSuccessfulVersion;
    }

    public String getDesiredVersion() {
        return this.desiredVersion;
    }

    public void setDesiredVersion(String desiredVersion) {
        this.desiredVersion = desiredVersion;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<Replica> getReplicas() {
        return this.replicas;
    }

    public void setReplicas(List<Replica> replicas) {
        this.replicas = replicas;
    }

    @JsonIgnore
    public ApplicationPropertiesService getApplicationPropertiesService() {
        ApplicationServices services;
        if (this.applicationState != null && (services = this.applicationState.getServices()) != null) {
            return services.getMuleAgentApplicationPropertiesService();
        }
        return null;
    }

    @JsonIgnore
    public Map<String, String> getNonSecureProperties() {
        ApplicationPropertiesService propertiesService = this.getApplicationPropertiesService();
        if (propertiesService != null && propertiesService.getProperties() != null) {
            return propertiesService.getProperties();
        }
        return Collections.emptyMap();
    }

    @JsonIgnore
    public Map<String, String> getSecureProperties() {
        ApplicationPropertiesService propertiesService = this.getApplicationPropertiesService();
        if (propertiesService != null && propertiesService.getSecureProperties() != null) {
            return propertiesService.getSecureProperties();
        }
        return Collections.emptyMap();
    }
}

