/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.auth;

import com.aeontronix.anypointsdk.auth.AnypointAuthenticationHandler;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.RESTResponse;
import com.aeontronix.restclient.json.JsonConvertionException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

public class AnypointClientCredentialsAuthenticationHandler
extends AnypointAuthenticationHandler {
    private String clientId;
    private String clientSecret;
    private LocalDateTime expires;
    private ObjectMapper objectMapper = new ObjectMapper();

    public AnypointClientCredentialsAuthenticationHandler(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public boolean isRefreshRequired() {
        return this.expires == null || LocalDateTime.now().isAfter(this.expires);
    }

    public boolean isRefreshable() {
        return true;
    }

    public void refreshCredential(RESTClient restClient) throws RESTException {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("grant_type", "client_credentials");
        payload.put("client_id", this.clientId);
        payload.put("client_secret", this.clientSecret);
        try (RESTResponse response = restClient.post().jsonBody(payload).execute();){
            Map res = (Map)response.toObject(Map.class);
            this.expires = LocalDateTime.now().plusSeconds(((Integer)res.get("expires_in")).intValue());
            this.setBearerToken((String)res.get("access_token"));
        }
        catch (RESTException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RESTException(e.getMessage(), (Throwable)e);
        }
        catch (JsonConvertionException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }
}

