/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.cli;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.amc.AMCAppDeploymentParameters;
import com.aeontronix.anypointsdk.amc.AMCDeploymentResponse;
import com.aeontronix.anypointsdk.amc.application.ExchangeApplicationSource;
import com.aeontronix.anypointsdk.cli.AbstractCmd;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="deploy")
public class CH2DeployAppCmd
extends AbstractCmd
implements Callable<Integer> {
    @CommandLine.Option(names={"-a", "--appname"}, required=true)
    private String appName;
    @CommandLine.Option(names={"-t", "--target"}, required=true)
    private String targetId;
    @CommandLine.Option(names={"-o", "--org"}, required=true)
    private String orgId;
    @CommandLine.Option(names={"-e", "--env"}, required=true)
    private String envId;
    @CommandLine.Option(names={"-ao", "--asset-org"})
    private String assetOrgId;
    @CommandLine.Option(names={"-i", "--asset-artifact-id"}, required=true)
    private String assetArtifactId;
    @CommandLine.Option(names={"-v", "--asset-version"}, required=true)
    private String assetVersion;
    @CommandLine.Option(names={"--force"}, required=false)
    private boolean force;

    @Override
    public Integer call() throws Exception {
        AnypointClient client = this.getClient();
        AMCAppDeploymentParameters req = new AMCAppDeploymentParameters();
        AMCDeploymentResponse response = client.getAMCClient().deployApplication(req, this.appName, this.orgId, this.envId, this.targetId, new ExchangeApplicationSource(this.assetOrgId != null ? this.assetOrgId : this.orgId, this.assetArtifactId, this.assetVersion), new HashMap<String, String>(), new HashSet<String>(), null, this.force);
        response.waitDeploymentComplete(Duration.ofMinutes(5L), 2500L);
        return 0;
    }
}

