/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.cli;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.auth.credentials.AnypointBearerTokenCredentials;
import com.aeontronix.anypointsdk.auth.credentials.AnypointCredentials;
import com.aeontronix.anypointsdk.cli.AbstractCmd;
import com.aeontronix.anypointsdk.cli.CH2Cmd;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import picocli.CommandLine;

@CommandLine.Command(name="anypoint", subcommands={CH2Cmd.class})
public class MainCLI
extends AbstractCmd {
    @CommandLine.Option(names={"--bearer", "-b"})
    private String bearer;
    private AnypointClient client;

    @Override
    public AnypointClient getClient() {
        try {
            if (this.client == null) {
                Map profile;
                Object credentialsMap;
                ObjectMapper objectMapper;
                Map cfg;
                Map profiles;
                if (this.bearer != null) {
                    return AnypointClient.builder().credentials(new AnypointBearerTokenCredentials(this.bearer)).build();
                }
                File cfgFile = new File(System.getProperty("user.home") + File.separator + ".enhanced-mule.config.json");
                if (cfgFile.exists() && (profiles = (Map)(cfg = (Map)(objectMapper = new ObjectMapper()).readValue(cfgFile, Map.class)).get("profiles")) != null && (credentialsMap = (profile = (Map)profiles.get(cfg.getOrDefault("active", "default"))).get("credentials")) != null) {
                    AnypointCredentials credentials = (AnypointCredentials)objectMapper.convertValue(credentialsMap, AnypointCredentials.class);
                    return AnypointClient.builder().credentials(credentials).build();
                }
                throw new IllegalArgumentException("Credentials missing");
            }
            return this.client;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        MainCLI command = new MainCLI();
        int stc = new CommandLine((Object)command).execute(args);
        if (stc != 0) {
            System.exit(stc);
        }
    }
}

