/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.cloudhub;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.AnypointException;
import com.aeontronix.anypointsdk.cloudhub.CHApplication;
import com.aeontronix.anypointsdk.cloudhub.CHApplicationData;
import com.aeontronix.anypointsdk.cloudhub.CHMuleVersion;
import com.aeontronix.anypointsdk.util.SecurityHelper;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.restclient.RESTClientHost;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.RESTResponse;
import com.aeontronix.restclient.errorhandling.RESTAuthenticationException;
import com.aeontronix.restclient.errorhandling.RESTSecurityException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudhubClient {
    private static final Logger logger = LoggerFactory.getLogger(CloudhubClient.class);
    public static final String PATH_LIST_CH_APPS = "cloudhub/api/v2/applications";
    private final RESTClientHost restClient;
    private AnypointClient anypointClient;

    public CloudhubClient(AnypointClient anypointClient) {
        this.anypointClient = anypointClient;
        this.restClient = anypointClient.getAnypointRestClient();
    }

    public List<CHApplication> listCHApplications(String envId) throws AnypointException {
        return this.listCHApplications(envId, false, null, null);
    }

    public List<CHApplication> listCHApplications(String envId, boolean retrieveStatistics, Long statsPeriod, Long statsIntervalCount) throws AnypointException {
        try {
            try {
                return this.restClient.get().path(PATH_LIST_CH_APPS).queryParam("period", statsPeriod).queryParam("intervalCount", statsIntervalCount).queryParam("retrieveStatistics", retrieveStatistics).build().header("X-ANYPNT-ENV-ID", envId).executeAndConvertToList(CHApplicationData.class).stream().map(CHApplication::new).collect(Collectors.toList());
            }
            catch (RESTAuthenticationException e) {
                throw new AnypointException(SecurityHelper.authorizationFailed(this.anypointClient, (RESTSecurityException)e, "Unable to list cloudhub application in env " + envId, "Runtime Manager > Read Application"));
            }
        }
        catch (RESTException e) {
            throw new AnypointException(e);
        }
    }

    public Optional<CHApplication> describeApplication(String orgId, String envId, String domain) throws RESTException {
        try {
            return Optional.of((CHApplication)this.restClient.get().path(PATH_LIST_CH_APPS).pathEl(new String[]{domain}).build().header("X-ANYPNT-ORG-ID", orgId).header("X-ANYPNT-ENV-ID", envId).executeAndConvertToObject(CHApplication.class));
        }
        catch (RESTException e) {
            if (e.getStatusCode() == 404) {
                return Optional.empty();
            }
            throw e;
        }
    }

    public void downloadApplicationFile(String orgId, String envId, String appDomain, String filename, OutputStream os) throws RESTException {
        try (RESTResponse results = this.restClient.get().path("cloudhub/api/organizations/").pathEl(new String[]{orgId}).path("/environments/").pathEl(new String[]{envId}).path("/applications/").pathEl(new String[]{appDomain}).path("/download").pathEl(new String[]{filename}).build().execute();){
            IOUtils.copy((InputStream)results.getContentStream(), (OutputStream)os);
        }
        catch (IOException e) {
            throw new RESTException((Throwable)e);
        }
    }

    public List<CHMuleVersion> findCHMuleVersions() throws RESTException {
        return this.restClient.get("/cloudhub/api/mule-versions").executeAndConvertToList(CHMuleVersion.class, "/data");
    }

    public CHMuleVersion findDefaultCHMuleVersion() throws RESTException {
        for (CHMuleVersion version : this.findCHMuleVersions()) {
            if (!version.isRecommended()) continue;
            return version;
        }
        throw new UnexpectedException("No default mule version found");
    }
}

