/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.exchange;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.commons.file.TempFile;
import com.aeontronix.restclient.RESTClientRequestBuilder;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.RESTResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class CreateExchangeAssetRequest {
    private boolean syncPublish = true;
    private AnypointClient anypointClient;
    private String orgId;
    private String groupId;
    private String assetId;
    private String version;
    private String name;
    private String description;
    private String type;
    private List<String> dependencies;
    private List<String> keywords;
    private List<String> tags;
    private Map<String, Set<String>> fields;
    private Map<String, Set<String>> categories;
    private String contactName;
    private String contactEmail;
    private Map<String, String> properties;
    private final List<FileFilePart> files = new ArrayList<FileFilePart>();
    private Status status = Status.PUBLISHED;

    CreateExchangeAssetRequest(AnypointClient anypointClient) {
        this.anypointClient = anypointClient;
    }

    CreateExchangeAssetRequest(AnypointClient anypointClient, String orgId, String assetId, String version, String name) {
        this.anypointClient = anypointClient;
        this.orgId = orgId;
        this.groupId = orgId;
        this.assetId = assetId;
        this.version = version;
        this.orgId = orgId;
        this.name = name;
    }

    public RESTResponse execute() throws IOException, RESTException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        CreateExchangeAssetRequest.addPart(builder, "name", this.name);
        CreateExchangeAssetRequest.addPart(builder, "description", this.description);
        CreateExchangeAssetRequest.addPart(builder, "type", this.type);
        CreateExchangeAssetRequest.addPart(builder, "dependencies", this.dependencies);
        CreateExchangeAssetRequest.addPart(builder, "keywords", this.keywords);
        CreateExchangeAssetRequest.addPart(builder, "tags", this.tags);
        CreateExchangeAssetRequest.addPart(builder, "fields", this.fields);
        CreateExchangeAssetRequest.addPart(builder, "categories", this.categories);
        CreateExchangeAssetRequest.addPart(builder, "contactName", this.contactName);
        CreateExchangeAssetRequest.addPart(builder, "contactEmail", this.contactEmail);
        CreateExchangeAssetRequest.addPart(builder, "status", this.status.name().toLowerCase());
        if (this.properties != null && !this.properties.isEmpty()) {
            for (Map.Entry entry : this.properties.entrySet()) {
                CreateExchangeAssetRequest.addPart(builder, "properties." + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (FileFilePart fileFilePart : this.files) {
            builder = fileFilePart.addPart(builder);
        }
        try (TempFile tmp = new TempFile("exchast");){
            String contentEncodingHeaderValue;
            String contentEncodingHeaderKey;
            String contentTypeHeaderValue;
            String string;
            HttpEntity entity;
            try (FileOutputStream fos = new FileOutputStream((File)tmp);){
                entity = builder.build();
                Header contentTypeHeader = entity.getContentType();
                string = contentTypeHeader.getName();
                contentTypeHeaderValue = contentTypeHeader.getValue();
                Header contentEncoding = entity.getContentEncoding();
                contentEncodingHeaderKey = contentEncoding != null ? contentEncoding.getName() : null;
                contentEncodingHeaderValue = contentEncoding != null ? contentEncoding.getValue() : null;
                entity.writeTo((OutputStream)fos);
            }
            RESTClientRequestBuilder requestBuilder = this.anypointClient.getAnypointRestClient().post().path("/exchange/api/v2/organizations").pathEl(new String[]{this.orgId, "assets", this.groupId != null ? this.groupId : this.orgId, this.assetId, this.version}).build().entity((InputStream)new FileInputStream((File)tmp)).header(string, contentTypeHeaderValue).header("x-sync-publication", Boolean.toString(this.syncPublish));
            if (string != null && contentEncodingHeaderValue != null) {
                requestBuilder = requestBuilder.header(contentEncodingHeaderKey, contentEncodingHeaderValue);
            }
            try {
                entity = requestBuilder.execute();
                return entity;
            }
            catch (RESTException e) {
                String message = e.getMessage();
                if (e.getStatusCode() == 400 && message != null && message.contains("trying to set type: app. Expected type is: rest-api")) {
                    message = "Unable to upload application with artifact id " + this.assetId + " because there is an API specification with the same id. When deploying to RTF or CH2 your application's artifactId (in the pom.xml file)  must have a different id from your REST API Specification exchange id";
                    throw new RESTException(message, e.getReason(), Integer.valueOf(e.getStatusCode()));
                }
                throw e;
            }
        }
    }

    public CreateExchangeAssetRequest syncPublish(boolean syncPublish) {
        this.syncPublish = syncPublish;
        return this;
    }

    public CreateExchangeAssetRequest groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public CreateExchangeAssetRequest assetId(String assetId) {
        this.assetId = assetId;
        return this;
    }

    public CreateExchangeAssetRequest version(String version) {
        this.version = version;
        return this;
    }

    public CreateExchangeAssetRequest orgId(String orgId) {
        this.orgId = orgId;
        return this;
    }

    public CreateExchangeAssetRequest name(String name) {
        this.name = name;
        return this;
    }

    public CreateExchangeAssetRequest description(String description) {
        this.description = description;
        return this;
    }

    public CreateExchangeAssetRequest type(String type) {
        this.type = type;
        return this;
    }

    public CreateExchangeAssetRequest dependencies(List<String> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public CreateExchangeAssetRequest keywords(List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    public CreateExchangeAssetRequest tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public CreateExchangeAssetRequest fields(Map<String, Set<String>> fields) {
        this.fields = fields;
        return this;
    }

    public CreateExchangeAssetRequest categories(Map<String, Set<String>> categories) {
        this.categories = categories;
        return this;
    }

    public CreateExchangeAssetRequest contactName(String contactName) {
        this.contactName = contactName;
        return this;
    }

    public CreateExchangeAssetRequest contactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
        return this;
    }

    public CreateExchangeAssetRequest properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public CreateExchangeAssetRequest file(String packaging, String classifier, String contentType, String filename, File file) {
        this.files.add(new FileFilePart(packaging, classifier, contentType, filename, file));
        return this;
    }

    public CreateExchangeAssetRequest files(List<FileFilePart> files) {
        this.files.clear();
        this.files.addAll(files);
        return this;
    }

    private static void addPart(MultipartEntityBuilder builder, String prefix, Map<String, Set<String>> values) {
        if (values != null && !values.isEmpty()) {
            for (Map.Entry<String, Set<String>> entry : values.entrySet()) {
                CreateExchangeAssetRequest.addPart(builder, prefix + "." + entry.getKey(), (Collection<String>)entry.getValue());
            }
        }
    }

    private static void addPart(MultipartEntityBuilder builder, String key, Collection<String> values) {
        if (values != null && !values.isEmpty()) {
            CreateExchangeAssetRequest.addPart(builder, key, values.stream().collect(Collectors.joining(",")));
        }
    }

    private static void addPart(MultipartEntityBuilder builder, String key, String value) {
        if (value != null) {
            builder.addTextBody(key, value);
        }
    }

    public CreateExchangeAssetRequest status(Status status) {
        this.status = status;
        return this;
    }

    public static enum Status {
        DEVELOPMENT,
        PUBLISHED,
        DEPRECATED;

    }

    public static class FileFilePart
    extends FilePart {
        private File file;

        public FileFilePart(String packaging, String classifier, String contentType, String filename, File file) {
            super(packaging, classifier, contentType, filename != null ? filename : file.getPath());
            this.file = file;
        }

        @Override
        public MultipartEntityBuilder addPart(MultipartEntityBuilder builder) {
            String classifier = this.getClassifier();
            String packaging = this.getPackaging();
            if (classifier == null) {
                if (this.file.getName().endsWith("-mule-application.jar")) {
                    classifier = "mule-application";
                } else {
                    throw new IllegalArgumentException("Classifier not specified and couldn't be identified");
                }
            }
            if (packaging == null) {
                throw new IllegalArgumentException("Packaging not specified and couldn't be identified");
            }
            return builder.addBinaryBody("files." + classifier + "." + packaging, this.file);
        }
    }

    public static abstract class FilePart {
        private String packaging;
        private String classifier;
        private String contentType;
        private String filename;

        FilePart(String packaging, String classifier, String contentType, String filename) {
            this.packaging = packaging;
            this.classifier = classifier;
            this.contentType = contentType;
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getPackaging() {
            return this.packaging;
        }

        public void setPackaging(String packaging) {
            this.packaging = packaging;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public void setClassifier(String classifier) {
            this.classifier = classifier;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public abstract MultipartEntityBuilder addPart(MultipartEntityBuilder var1);
    }
}

