/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.exchange;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.apimanager.APIContractData;
import com.aeontronix.anypointsdk.exchange.CreateExchangeAssetRequest;
import com.aeontronix.anypointsdk.exchange.ExchangeClientApplication;
import com.aeontronix.anypointsdk.exchange.ExchangeClientApplicationData;
import com.aeontronix.anypointsdk.exchange.asset.ExchangeAsset;
import com.aeontronix.anypointsdk.exchange.asset.ExchangeAssetData;
import com.aeontronix.anypointsdk.exchange.asset.FileDetails;
import com.aeontronix.anypointsdk.util.SecurityHelper;
import com.aeontronix.commons.exception.NotFoundException;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.restclient.PaginatedResponse;
import com.aeontronix.restclient.RESTClientHostPathBuilder;
import com.aeontronix.restclient.RESTClientRequestBuilder;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.RESTResponse;
import com.aeontronix.restclient.errorhandling.RESTSecurityException;
import com.aeontronix.restclient.json.JsonConvertionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ExchangeClient {
    private AnypointClient anypointClient;

    public ExchangeClient(AnypointClient anypointClient) {
        this.anypointClient = anypointClient;
    }

    public CreateExchangeAssetRequest createAsset() {
        return new CreateExchangeAssetRequest(this.anypointClient);
    }

    public CreateExchangeAssetRequest createAsset(String orgId, String assetId, String version, String name) {
        return new CreateExchangeAssetRequest(this.anypointClient, orgId, assetId, version, name);
    }

    public List<ExchangeClientApplication> listAllClientApplications(String orgId) throws RESTException {
        List<ExchangeClientApplication> list;
        block9: {
            PaginatedResponse response = ((RESTClientRequestBuilder)((RESTClientRequestBuilder)this.anypointClient.getAnypointRestClient().get().path("/exchange/api/v1/organizations").path(orgId).path("/applications").build().paginate()).pageValuesPath("")).executePaginated(ExchangeClientApplicationData.class);
            try {
                list = response.toList().stream().map(ExchangeClientApplication::new).collect(Collectors.toList());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RESTSecurityException e) {
                    throw SecurityHelper.authorizationFailed(this.anypointClient, e, "Unable to list all client applications");
                }
                catch (IOException e) {
                    throw new RESTException((Throwable)e);
                }
            }
            response.close();
        }
        return list;
    }

    public ExchangeClientApplication findClientApplicationById(String orgId, String id) throws RESTException {
        try {
            return new ExchangeClientApplication((ExchangeClientApplicationData)this.anypointClient.getAnypointRestClient().get().path("/exchange/api/v1/organizations").path(orgId).path("/applications").path(id).build().executeAndConvertToObject(ExchangeClientApplicationData.class));
        }
        catch (RESTException e) {
            if (e.getStatusCode() == 403) {
                throw new RESTException("Client application either doesn't exist or not authorized to access", e.getReason(), Integer.valueOf(e.getStatusCode()));
            }
            throw e;
        }
    }

    public ExchangeClientApplication createClientApplication(@NotNull String masterOrgId, ExchangeClientApplicationData applicationData, String apiInstanceId) throws RESTException {
        try {
            RESTClientHostPathBuilder path = this.anypointClient.getAnypointRestClient().post().path("/exchange/api/v2/organizations/").path(masterOrgId).path("/applications");
            if (apiInstanceId != null) {
                path.queryParam("apiInstanceId", apiInstanceId);
            }
            return new ExchangeClientApplication((ExchangeClientApplicationData)path.build().jsonBody((Object)applicationData).executeAndConvertToObject(ExchangeClientApplicationData.class));
        }
        catch (JsonConvertionException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public ExchangeClientApplication updateClientApplication(@NotNull String masterOrgId, ExchangeClientApplicationData applicationData) throws RESTException {
        try {
            return new ExchangeClientApplication((ExchangeClientApplicationData)this.anypointClient.getAnypointRestClient().patch().path("/exchange/api/v2/organizations/").path(masterOrgId).path("/applications").path(Integer.toString(applicationData.getId())).build().jsonBody((Object)applicationData).executeAndConvertToObject(ExchangeClientApplicationData.class));
        }
        catch (JsonConvertionException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public APIContractData createAPIContract(String applicationId, String apiId, String organizationId, String environmentId, boolean acceptedTerms, String groupId, String assetId, String version, String productAPIVersion, Long tierId) throws RESTException {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("apiId", apiId);
        req.put("environmentId", environmentId);
        req.put("acceptedTerms", acceptedTerms);
        req.put("organizationId", organizationId);
        req.put("groupId", groupId);
        req.put("assetId", assetId);
        req.put("version", version);
        req.put("productAPIVersion", productAPIVersion);
        if (tierId != null) {
            req.put("requestedTierId", tierId);
        }
        try {
            return (APIContractData)this.anypointClient.getAnypointRestClient().post().path("/exchange/api/v1/organizations/").path(organizationId).path("/applications/").path(applicationId).path("/contracts").build().jsonBody(req).executeAndConvertToObject(APIContractData.class);
        }
        catch (JsonConvertionException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public ExchangeAsset findAssetById(String groupId, String assetId, String version) throws RESTException {
        return new ExchangeAsset((ExchangeAssetData)this.anypointClient.getAnypointRestClient().get().path("/exchange/api/v2/assets").path(groupId).path(assetId).path(version).path("asset").build().executeAndConvertToObject(ExchangeAssetData.class));
    }

    public void downloadApplication(String groupId, String artifactId, String version, OutputStream os) throws NotFoundException, RESTException, IOException {
        ExchangeAsset asset = this.findAssetById(groupId, artifactId, version);
        FileDetails fileDetails = asset.getData().getFiles().stream().filter(p -> p.getClassifier() != null && p.getClassifier().equals("mule-application")).findFirst().orElseThrow(() -> new NotFoundException("Application archive not found in asset"));
        try (RESTResponse response = this.anypointClient.getRestClient().get(fileDetails.getExternalLink()).execute();){
            IOUtils.copy((InputStream)response.getContentStream(), (OutputStream)os);
        }
    }
}

