/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.URLBuilder;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.authentication.AuthenticationProviderBearerTokenImpl;
import com.aeontronix.enhancedmule.tools.config.AnypointBearerTokenCredentialsProvider;
import com.aeontronix.enhancedmule.tools.config.ConfigProfile;
import com.aeontronix.enhancedmule.tools.config.CredentialsProvider;
import com.aeontronix.enhancedmule.tools.exchange.ExchangeClient;
import com.aeontronix.enhancedmule.tools.util.restclient.RESTAuthenticationProvider;
import com.aeontronix.enhancedmule.tools.util.restclient.RESTClient;
import com.aeontronix.enhancedmule.tools.util.restclient.RESTClientJsonParserJacksonImpl;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class EnhancedMuleClient
implements Closeable,
AutoCloseable {
    public static final String EMULE_SERVER_URL = "https://api.enhanced-mule.com";
    private RESTClient restClient;
    private CredentialsProvider credentialsProvider;
    private String anypointPlatformUrl = "https://anypoint.mulesoft.com/";
    private String exchangeMavenBaseUrl = "https://maven.anypoint.mulesoft.com";
    private String exchangeMavenPath = "/api/v2/maven";
    private ExchangeClient exchangeClient;
    private String serverUrl;
    private String publicServerUrl;
    private ConfigProfile configProfile;

    public EnhancedMuleClient(ConfigProfile configProfile) {
        this(EMULE_SERVER_URL, configProfile);
    }

    public EnhancedMuleClient(String serverUrl, ConfigProfile configProfile) {
        this.configProfile = configProfile;
        this.restClient = new RESTClient(new RESTClientJsonParserJacksonImpl(), null, null, null);
        this.serverUrl = serverUrl;
        this.restClient.setBaseUrl(this.serverUrl);
        this.publicServerUrl = new URLBuilder(this.serverUrl).path("public").toString();
        this.restClient.addAuthProvider(new EMAccessTokenProvider());
        this.restClient.addAuthProvider(new MavenAuthenticationProvider());
        this.exchangeClient = new ExchangeClient(this.restClient, this.exchangeMavenBaseUrl);
    }

    public void setProxy(HttpHost proxyHost, String proxyUsername, String proxyPassword) {
        this.restClient.setProxy(proxyHost, proxyUsername, proxyPassword);
    }

    public ConfigProfile getConfigProfile() {
        return this.configProfile;
    }

    public ExchangeClient getExchangeClient() {
        return this.exchangeClient;
    }

    public RESTClient getRestClient() {
        return this.restClient;
    }

    @Override
    public void close() throws IOException {
        this.restClient.close();
    }

    public CredentialsProvider getCredentialsLoader() {
        return this.credentialsProvider;
    }

    public void setCredentialsLoader(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public AnypointClient getAnypointClient() throws IOException {
        if (this.credentialsProvider instanceof AnypointBearerTokenCredentialsProvider) {
            String anypointBearerToken = ((AnypointBearerTokenCredentialsProvider)this.credentialsProvider).getAnypointBearerToken(this);
            return new AnypointClient(new AuthenticationProviderBearerTokenImpl(anypointBearerToken));
        }
        throw new RuntimeException("not implemented");
    }

    public String getAnypointPlatformUrl() {
        return this.anypointPlatformUrl;
    }

    public void setAnypointPlatformUrl(String anypointPlatformUrl) {
        this.anypointPlatformUrl = anypointPlatformUrl;
    }

    public String getExchangeMavenUrl() {
        return this.exchangeMavenBaseUrl + this.exchangeMavenPath;
    }

    public String getExchangeMavenBaseUrl() {
        return this.exchangeMavenBaseUrl;
    }

    public void setExchangeMavenBaseUrl(String exchangeMavenBaseUrl) {
        this.exchangeMavenBaseUrl = exchangeMavenBaseUrl;
    }

    public String getAnypointBearerToken() throws IOException {
        if (this.credentialsProvider instanceof AnypointBearerTokenCredentialsProvider) {
            return ((AnypointBearerTokenCredentialsProvider)this.credentialsProvider).getAnypointBearerToken(this);
        }
        return this.restClient.get("/anypoint/bearer").execute(String.class);
    }

    public class EMAccessTokenProvider
    implements RESTAuthenticationProvider {
        private String bearer;

        @Override
        public boolean handles(HttpRequest req) {
            if (req instanceof HttpRequestWrapper) {
                HttpRequestWrapper wrapper = (HttpRequestWrapper)req;
                return wrapper.getTarget().toString().startsWith(EnhancedMuleClient.this.serverUrl) && !wrapper.getURI().toString().startsWith("/public");
            }
            if (req instanceof HttpUriRequest) {
                String url = ((HttpUriRequest)req).getURI().toString();
                return url.startsWith(EnhancedMuleClient.this.serverUrl) && !url.startsWith(EnhancedMuleClient.this.publicServerUrl);
            }
            return false;
        }

        @Override
        public void process(HttpRequest req, HttpContext httpContext) throws IOException {
            if (this.bearer == null) {
                Map authResult = EnhancedMuleClient.this.restClient.postJson("/public/auth", EnhancedMuleClient.this.credentialsProvider.getCredentials().toAuthRequestPayload()).execute(Map.class);
                this.bearer = (String)authResult.get("accessToken");
                if (StringUtils.isBlank((String)this.bearer)) {
                    throw new IOException("No access token return by authentication");
                }
            }
            req.addHeader((Header)new BasicHeader("Authorization", "Bearer " + this.bearer));
        }
    }

    public class MavenAuthenticationProvider
    implements RESTAuthenticationProvider {
        @Override
        public boolean handles(HttpRequest req) {
            return req instanceof HttpRequestWrapper && ((HttpRequestWrapper)req).getTarget().toString().startsWith(EnhancedMuleClient.this.exchangeMavenBaseUrl) || req instanceof HttpUriRequest && ((HttpUriRequest)req).getURI().toString().startsWith(EnhancedMuleClient.this.exchangeMavenBaseUrl);
        }

        @Override
        public void process(HttpRequest req, HttpContext httpContext) throws IOException {
            String authStr = "~~~Token~~~:" + EnhancedMuleClient.this.getAnypointBearerToken();
            req.addHeader((Header)new BasicHeader("Authorization", "Basic " + StringUtils.base64Encode((byte[])authStr.getBytes())));
        }
    }
}

