/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint;

import com.aeontronix.commons.BackendAccessException;
import com.aeontronix.commons.TempFile;
import com.aeontronix.commons.ThreadUtils;
import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.EnhancedMuleClient;
import com.aeontronix.enhancedmule.tools.alert.Alert;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.VPC;
import com.aeontronix.enhancedmule.tools.anypoint.VPCInternalDns;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetCreationException;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetList;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetVersion;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAsset;
import com.aeontronix.enhancedmule.tools.api.APIAsset;
import com.aeontronix.enhancedmule.tools.api.APISpec;
import com.aeontronix.enhancedmule.tools.api.APISpecList;
import com.aeontronix.enhancedmule.tools.api.ClientApplication;
import com.aeontronix.enhancedmule.tools.api.ClientApplicationList;
import com.aeontronix.enhancedmule.tools.api.DesignCenterProject;
import com.aeontronix.enhancedmule.tools.application.ApplicationArchiveVersionTransformer;
import com.aeontronix.enhancedmule.tools.application.ApplicationIdentifier;
import com.aeontronix.enhancedmule.tools.application.MavenHelper;
import com.aeontronix.enhancedmule.tools.fabric.Fabric;
import com.aeontronix.enhancedmule.tools.legacy.deploy.FileApplicationSource;
import com.aeontronix.enhancedmule.tools.provisioning.AlertDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.EnvironmentDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.OrganizationDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.RoleDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.RolePermissionDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.VPCOrgProvisioningDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.VPCProvisioningDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIDescriptor;
import com.aeontronix.enhancedmule.tools.role.ProductPermissions;
import com.aeontronix.enhancedmule.tools.role.Role;
import com.aeontronix.enhancedmule.tools.role.RoleAssignment;
import com.aeontronix.enhancedmule.tools.role.RoleGroup;
import com.aeontronix.enhancedmule.tools.role.RoleGroupList;
import com.aeontronix.enhancedmule.tools.runtime.Target;
import com.aeontronix.enhancedmule.tools.runtime.manifest.ReleaseManifest;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.FileStreamSource;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.HttpHelper;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.aeontronix.unpack.FileType;
import com.aeontronix.unpack.UnpackException;
import com.aeontronix.unpack.Unpacker;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Organization
extends AnypointObject {
    public static final Pattern MAJORVERSION_REGEX = Pattern.compile("(\\d*)\\..*");
    private static final Logger logger = LoggerFactory.getLogger(Organization.class);
    private static final EMTLogger eLogger = new EMTLogger(logger);
    @JsonProperty
    protected String id;
    @JsonProperty
    protected String name;
    @JsonProperty
    protected String parentId;
    @JsonProperty(value="isFederated")
    protected boolean federated;

    public Organization() {
    }

    public Organization(AnypointClient client) {
        super(client);
    }

    public Organization(AnypointClient client, String id) {
        super(client);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isFederated() {
        return this.federated;
    }

    public void setFederated(boolean federated) {
        this.federated = federated;
    }

    public List<Environment> findAllEnvironments() throws HttpException {
        return Environment.findEnvironmentsByOrg(this.client, this);
    }

    @NotNull
    public Environment findEnvironmentByName(@NotNull String name) throws NotFoundException, HttpException {
        return Environment.findEnvironmentByName(name, this.client, this);
    }

    @NotNull
    public Environment findEnvironmentById(@NotNull String id) throws NotFoundException, HttpException {
        return Environment.findEnvironmentById(id, this.client, this);
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Organization getParentOrganization() throws HttpException {
        if (this.parentId != null) {
            try {
                return this.client.findOrganizationById(this.parentId);
            }
            catch (NotFoundException e) {
                throw (HttpException)e.getCause();
            }
        }
        return null;
    }

    public Organization getRootOrganization() throws HttpException {
        if (this.parentId != null) {
            return this.getParentOrganization().getRootOrganization();
        }
        return this;
    }

    public Environment createEnvironment(@NotNull String name, @NotNull Environment.Type type) throws HttpException {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("name", name);
        request.put("type", type.name().toLowerCase());
        request.put("organizationId", this.id);
        String json = this.client.getHttpHelper().httpPost("https://anypoint.mulesoft.com/accounts/api/organizations/" + this.id + "/environments", request);
        return this.jsonHelper.readJson(this.createEnvironmentObject(), json);
    }

    public ClientApplication createClientApplication(String name, String url, String description) throws HttpException {
        return this.createClientApplication(name, url, description, null);
    }

    public ClientApplication createClientApplication(String name, String url, String description, String accessedAPIInstanceId) throws HttpException {
        return ClientApplication.create(this.getRootOrganization(), name, url, description, Collections.emptyList(), null, accessedAPIInstanceId);
    }

    public ClientApplication createClientApplication(String name, String url, String description, List<String> redirectUri, String apiEndpoints, String accessedAPIInstanceId) throws HttpException {
        return ClientApplication.create(this.getRootOrganization(), name, url, description, redirectUri, apiEndpoints, accessedAPIInstanceId);
    }

    public Organization createSubOrganization(String name, String ownerId, boolean createSubOrgs, boolean createEnvironments) throws HttpException {
        return this.createSubOrganization(name, ownerId, createSubOrgs, createEnvironments, false, 0, 0, 0, 0, 0, 0);
    }

    public List<ClientApplication> findAllClientApplications() throws HttpException {
        return this.findAllClientApplications(null);
    }

    public List<ClientApplication> findAllClientApplications(@Nullable String filter) throws HttpException {
        return ClientApplication.find(this.getRootOrganization(), filter);
    }

    public ClientApplication findClientApplicationById(@NotNull String id) throws HttpException, NotFoundException {
        String json = this.httpHelper.httpGet("/exchange/api/v1/organizations/" + this.id + "/applications/" + id);
        return this.jsonHelper.readJson(new ClientApplication(this), json);
    }

    public ClientApplication findClientApplicationByName(@NotNull String name) throws HttpException, NotFoundException {
        return this.findClientApplicationByName(name, true);
    }

    public ClientApplication findClientApplicationByName(@NotNull String name, boolean fullData) throws HttpException, NotFoundException {
        ClientApplication app = null;
        app = this.findClientApplicationByName(new ClientApplicationList(this, name), name, false);
        if (app == null) {
            app = this.findClientApplicationByName(this.findAllClientApplications(name), name, false);
        }
        if (app != null) {
            app = this.findClientApplicationById(app.getId().toString());
        }
        if (app == null) {
            throw new NotFoundException("Client application not found: " + name);
        }
        return app;
    }

    @Nullable
    private ClientApplication findClientApplicationByName(Iterable<ClientApplication> list, @NotNull String name, boolean fullData) throws HttpException {
        for (ClientApplication app : list) {
            if (!name.equals(app.getName())) continue;
            if (fullData) {
                return this.jsonHelper.readJson(app, this.httpHelper.httpGet(app.getUriPath()));
            }
            return app;
        }
        return null;
    }

    @NotNull
    public APISpecList findAPISpecs() throws HttpException {
        return this.findAPISpecsByFilter(null);
    }

    @NotNull
    public APISpecList findAPISpecsByFilter(@Nullable String filter) throws HttpException {
        return new APISpecList(this, filter);
    }

    public APISpec findAPISpecsByIdOrNameAndVersion(String idOrName, String version) throws NotFoundException, HttpException {
        for (APISpec apiSpec : this.findAPISpecs()) {
            if (!apiSpec.getAssetId().equalsIgnoreCase(idOrName) || !apiSpec.getVersion().equalsIgnoreCase(version)) continue;
            return apiSpec;
        }
        return this.findAPISpecsByNameAndVersion(idOrName, version);
    }

    public APISpec findAPISpecsByNameAndVersion(String name, String version) throws NotFoundException, HttpException {
        for (APISpec apiSpec : this.findAPISpecsByFilter(name)) {
            if (!apiSpec.getName().equalsIgnoreCase(name) || !apiSpec.getVersion().equalsIgnoreCase(version)) continue;
            return apiSpec;
        }
        throw new NotFoundException("Couldn't find api spec " + name + " " + version);
    }

    public Organization createSubOrganization(String name, String ownerId, boolean createSubOrgs, boolean createEnvironments, boolean globalDeployment, int vCoresProduction, int vCoresSandbox, int vCoresDesign, int staticIps, int vpcs, int loadBalancer) throws HttpException {
        JsonHelper.MapBuilder builder = this.client.getJsonHelper().buildJsonMap().set("name", name).set("parentOrganizationId", this.id).set("ownerId", ownerId);
        Map<String, Object> req = builder.addMap("entitlements").set("createSubOrgs", createSubOrgs).set("createEnvironments", createEnvironments).set("globalDeployment", globalDeployment).setNested("vCoresProduction", "assigned", vCoresProduction).setNested("vCoresSandbox", "assigned", vCoresSandbox).setNested("vCoresDesign", "assigned", vCoresDesign).setNested("staticIps", "assigned", staticIps).setNested("vpcs", "assigned", vpcs).setNested("loadBalancer", "assigned", loadBalancer).setNested("staticIps", "assigned", staticIps).toMap();
        String json = this.httpHelper.httpPost("/accounts/api/organizations", req);
        return this.jsonHelper.readJson(new Organization(this.client), json);
    }

    public void delete() throws HttpException {
        this.deleteSubElements();
        long timeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(60L);
        while (true) {
            try {
                this.httpHelper.httpDelete("/accounts/api/organizations/" + this.id);
            }
            catch (HttpException e) {
                if (System.currentTimeMillis() > timeout) {
                    throw e;
                }
                this.deleteSubElements();
                ThreadUtils.sleep((long)1500L);
                continue;
            }
            break;
        }
    }

    private void deleteSubElements() throws HttpException {
        for (Environment environment : this.findAllEnvironments()) {
            for (APIAsset api : environment.findAPIs(null)) {
                api.delete();
            }
        }
        this.findExchangeAssets().delete();
    }

    @JsonIgnore
    public String getUriPath() {
        return new URLBuilder("/apiplatform/repository/v2/organizations/").path(this.id).toString();
    }

    public String toString() {
        return "Organization{id='" + this.id + '\'' + ", name='" + this.name + '\'' + "} " + super.toString();
    }

    public List<DesignCenterProject> findDesignCenterProjects() throws HttpException {
        String json = this.httpHelper.httpGet("/designcenter/api/v1/organizations/" + this.id + "/projects?pageSize=500&pageIndex=0");
        return this.jsonHelper.readJsonList(DesignCenterProject.class, json, this);
    }

    public DesignCenterProject findDesignCenterProject(String name) throws NotFoundException, HttpException {
        for (DesignCenterProject project : this.findDesignCenterProjects()) {
            if (!name.equalsIgnoreCase(project.getName())) continue;
            return project;
        }
        throw new NotFoundException();
    }

    public DesignCenterProject createDesignCenterProject(String name, String type, boolean visualDesignerMode, String ownerId) throws HttpException {
        return DesignCenterProject.create(this, name, type, visualDesignerMode, ownerId);
    }

    public AssetList findExchangeAssets() throws HttpException {
        return new AssetList(this, null, 50);
    }

    public AssetList findExchangeAssets(String filter, int limit) throws HttpException {
        return new AssetList(this, filter, limit);
    }

    public ExchangeAsset findExchangeAsset(@NotNull String groupId, @NotNull String assetId) throws HttpException, NotFoundException {
        logger.debug("searching exchange asset, groupId=" + groupId + " assetId=" + assetId);
        try {
            String json = this.httpHelper.httpGet("/exchange/api/v2/assets/" + groupId + "/" + assetId);
            return this.jsonHelper.readJson(new ExchangeAsset(this), json);
        }
        catch (HttpException e) {
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Asset not found: " + groupId + ":" + assetId);
            }
            throw e;
        }
    }

    public AssetVersion findExchangeAssetVersion(@NotNull String groupId, @NotNull String assetId, @NotNull String version) throws HttpException, NotFoundException {
        for (AssetVersion assetVersion : this.findExchangeAsset(groupId, assetId).getVersions()) {
            if (!version.equals(assetVersion.getVersion())) continue;
            return assetVersion;
        }
        throw new NotFoundException("Asset not found: " + groupId + ":" + assetId + ":" + version);
    }

    @NotNull
    protected Environment createEnvironmentObject() {
        return new Environment(this);
    }

    @NotNull
    protected Class<? extends Environment> getEnvironmentClass() {
        return Environment.class;
    }

    public VPC provisionVPC(VPCProvisioningDescriptor vd, boolean deleteExisting) throws NotFoundException, HttpException {
        if (deleteExisting) {
            try {
                VPC preExistingVPC = this.findVPCByName(vd.getName());
                preExistingVPC.delete();
            }
            catch (NotFoundException e) {
                logger.debug("No pre-existing VPC exists");
            }
        }
        VPC vpc = new VPC(vd.getName(), vd.getCidrBlock(), vd.isDefaultVpc(), vd.getRegion());
        ArrayList<String> envIds = new ArrayList<String>();
        ArrayList<String> orgIds = new ArrayList<String>();
        for (String envName : vd.getEnvironments()) {
            Environment env = this.findEnvironmentByName(envName);
            envIds.add(env.getId());
        }
        for (VPCOrgProvisioningDescriptor o : vd.getOrganizations()) {
            Organization subOrg = this.client.findOrganizationByNameOrId(o.getName());
            orgIds.add(subOrg.getId());
        }
        vpc.setAssociatedEnvironments(envIds);
        vpc.setSharedWith(orgIds);
        vpc.setFirewallRules(vd.getFirewallRules());
        vpc.setInternalDns(new VPCInternalDns(vd.getDnsServers(), vd.getDnsDomains()));
        String json = this.client.getHttpHelper().httpPost("/cloudhub/api/organizations/" + this.id + "/vpcs", vpc);
        vpc = this.client.getJsonHelper().readJson(new VPC(), json);
        for (VPCOrgProvisioningDescriptor o : vd.getOrganizations()) {
            Organization subOrg = this.client.findOrganizationByNameOrId(o.getName());
            ArrayList<String> eId = new ArrayList<String>();
            for (String e : o.getEnvironments()) {
                Environment env = subOrg.findEnvironmentByName(e);
                eId.add(env.getId());
                Map<String, Object> req = this.jsonHelper.buildJsonMap().set("id", vpc.getId()).set("isDefault", vpc.isDefaultVpc()).set("associatedEnvironments", eId).toMap();
                this.client.httpHelper.anypointHttpPut("/cloudhub/api/organizations/" + subOrg.getId() + "/vpcs/" + vpc.getId(), req, env);
            }
        }
        return this.client.getJsonHelper().readJson(new VPC(), this.client.httpHelper.httpGet("/cloudhub/api/organizations/" + this.id + "/vpcs/" + vpc.getId()));
    }

    public void provisionVPC(File file, boolean deleteExisting) throws NotFoundException, HttpException, IOException {
        VPCProvisioningDescriptor vpcProvisioningDescriptor = (VPCProvisioningDescriptor)this.jsonHelper.getJsonMapper().readValue(file, VPCProvisioningDescriptor.class);
        this.provisionVPC(vpcProvisioningDescriptor, deleteExisting);
    }

    public List<VPC> findVPCs() throws HttpException {
        String json = this.httpHelper.httpGet("/cloudhub/api/organizations/" + this.id + "/vpcs/");
        return this.jsonHelper.readJsonList(VPC.class, json, this, "/data");
    }

    public VPC findVPCByName(String name) throws NotFoundException, HttpException {
        for (VPC vpc : this.findVPCs()) {
            if (!vpc.getName().equals(name)) continue;
            return vpc;
        }
        throw new NotFoundException("VPC " + name + " not found");
    }

    public List<Target> findAllTargets() throws HttpException {
        String json = this.httpHelper.httpGet("/runtimefabric/api/organizations/" + this.id + "/targets");
        return this.jsonHelper.readJsonList(Target.class, json, this);
    }

    public Target findTargetById(String id) throws NotFoundException, HttpException {
        for (Target target : this.findAllTargets()) {
            if (!target.getId().equals(id)) continue;
            return target;
        }
        throw new NotFoundException("Target not found: " + id);
    }

    public ReleaseManifest findExchangeReleaseManifest(String uri) {
        String name = "Release Manifest: " + this.id;
        String artifactId = "relmanifest-" + this.id;
        try {
            logger.debug("Searching exchange assets " + this.id + " : " + artifactId);
            ExchangeAsset asset = this.findExchangeAsset(this.id, artifactId);
            int oldestVersion = 0;
            for (AssetVersion assetVersion : asset.getVersions()) {
                String v = assetVersion.getVersion();
                Matcher m = MAJORVERSION_REGEX.matcher(v);
                logger.debug("Found version" + v);
                if (!m.find()) {
                    throw new IllegalStateException("Invalid manifest version in exchange: " + v);
                }
                try {
                    int vNb = Integer.parseInt(m.group(1));
                    if (vNb <= oldestVersion) continue;
                    oldestVersion = vNb;
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Invalid manifest version in exchange: " + v);
                }
            }
            String version = oldestVersion + ".0.0";
        }
        catch (HttpException e) {
            throw new BackendAccessException((Throwable)e);
        }
        catch (NotFoundException e) {
            String version = "1.0.0";
        }
        return null;
    }

    @NotNull
    public RoleGroupList findAllRoleGroups() throws HttpException {
        return new RoleGroupList(this);
    }

    public RoleGroup findRoleGroupById(String roleId) throws HttpException, NotFoundException {
        return RoleGroup.findById(this, this.httpHelper, this.jsonHelper, roleId);
    }

    public List<ProductPermissions> findAllProductPermissions() throws HttpException {
        String json = this.httpHelper.httpGet("/accounts/api/cs/organizations/" + this.id + "/permissions/products");
        return this.jsonHelper.readJsonList(ProductPermissions.class, json, this);
    }

    public List<Role> findAllRoles() throws HttpException {
        ArrayList<Role> results = new ArrayList<Role>();
        for (ProductPermissions pp : this.findAllProductPermissions()) {
            results.addAll(pp.getRoles());
        }
        return results;
    }

    public Map<String, Role> findAllRolesIndexedByName() throws HttpException {
        return this.findAllRoles().stream().collect(Collectors.toMap(Role::getName, v -> v));
    }

    public RoleGroup createRoleGroup(String name, String description) throws HttpException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("name", name);
        req.put("description", description);
        String json = this.httpHelper.httpPost("/accounts/api/organizations/" + this.id + "/rolegroups?include_internal=false", req);
        return this.jsonHelper.readJson(new RoleGroup(), json, this);
    }

    public RoleGroup findRoleGroupByName(String name) throws HttpException, NotFoundException {
        for (RoleGroup roleGroup : this.findAllRoleGroups()) {
            if (!roleGroup.getName().equals(name)) continue;
            return roleGroup;
        }
        throw new NotFoundException("Rolegroup named " + name + " not found");
    }

    public void createExchangeHTTPAPIAsset(String groupId, String name, String assetId, String version, String apiVersion) throws AssetCreationException {
        HttpHelper.MultiPartRequest req = this.httpHelper.createAnypointMultiPartPostRequest("/exchange/api/v1/assets", null);
        req.addText("organizationId", this.id);
        req.addText("groupId", groupId == null ? this.id : groupId);
        req.addText("assetId", assetId);
        req.addText("version", version);
        req.addText("name", name);
        req.addText("classifier", "http");
        req.addText("apiVersion", apiVersion);
        req.addText("asset", "undefined");
        try {
            req.execute();
        }
        catch (IOException e) {
            throw new AssetCreationException(e);
        }
    }

    public OrganizationDescriptor export(boolean stripIds) throws HttpException {
        ModelMapper mapper = this.client.getModelMapper();
        OrganizationDescriptor org = new OrganizationDescriptor();
        mapper.map((Object)this, (Object)org);
        if (stripIds) {
            org.setParentId(null);
            org.setId(null);
        }
        this.exportAlerts(mapper, org, stripIds);
        return org;
    }

    private void exportAlerts(ModelMapper mapper, OrganizationDescriptor org, boolean stripIds) throws HttpException {
        ArrayList<AlertDescriptor> alerts = new ArrayList<AlertDescriptor>();
        org.setRuntimeAlerts(alerts);
        for (Environment environment : this.findAllEnvironments()) {
            for (Alert alert : environment.findAlerts()) {
                AlertDescriptor alertDesc = new AlertDescriptor();
                mapper.map((Object)alert, (Object)alertDesc);
                if (stripIds) {
                    alertDesc.setId(null);
                }
                alerts.add(alertDesc);
            }
        }
    }

    private void exportEnvironments(ModelMapper mapper, OrganizationDescriptor org, boolean stripIds) throws HttpException {
        List environments = (List)mapper.map(this.findAllEnvironments(), new TypeToken<List<EnvironmentDescriptor>>(){}.getType());
        org.setEnvironments(environments);
    }

    private void exportRoleGroups(ModelMapper mapper, OrganizationDescriptor org, boolean stripIds) throws HttpException, NotFoundException {
        ArrayList<RoleDescriptor> roles = new ArrayList<RoleDescriptor>();
        for (RoleGroup roleGroup : this.findAllRoleGroups()) {
            if (!roleGroup.isEditable()) continue;
            RoleDescriptor role = new RoleDescriptor();
            roles.add(role);
            mapper.map((Object)roleGroup, (Object)role);
            if (stripIds) {
                role.setId(null);
            }
            ArrayList<RolePermissionDescriptor> rolePermissions = new ArrayList<RolePermissionDescriptor>();
            role.setPermissions(rolePermissions);
            HashMap<String, RolePermissionDescriptor> rolePermissionsIdx = new HashMap<String, RolePermissionDescriptor>();
            for (RoleAssignment roleAssignment : roleGroup.findRoleAssignments()) {
                String roleId = roleAssignment.getRoleId();
                RolePermissionDescriptor rp = (RolePermissionDescriptor)rolePermissionsIdx.get(roleId);
                if (rp == null) {
                    rp = new RolePermissionDescriptor();
                    mapper.map((Object)roleAssignment, (Object)rp);
                    if (stripIds) {
                        rp.setId(null);
                        rp.setRoleId(null);
                    }
                    rolePermissionsIdx.put(roleId, rp);
                    rolePermissions.add(rp);
                }
                String raOrgId = roleAssignment.getContextParams().get("org");
                String raEnvId = roleAssignment.getContextParams().get("envId");
                HashMap<String, Environment> envCache = new HashMap<String, Environment>();
                if (raEnvId == null) continue;
                Environment raEnv = (Environment)envCache.get(raEnvId);
                if (raEnv == null) {
                    Organization raOrg = this.id.equals(raOrgId) ? this : this.client.findOrganizationById(raOrgId);
                    raEnv = raOrg.findEnvironmentById(raEnvId);
                    envCache.put(raEnvId, raEnv);
                }
                rp.addEnvironment(raEnv.getName());
            }
        }
        org.setRoles(roles);
    }

    @NotNull
    private Role findRoleById(String roleId) throws HttpException, NotFoundException {
        return this.findAllRoles().stream().filter(r -> r.getId().equals(roleId)).findFirst().orElseThrow(() -> new NotFoundException("Role " + roleId + " not found"));
    }

    public ExchangeAsset publishExchangeAPIAsset(String name, String assetId, String assetVersion, String assetAPIVersion, String assetClassifier, String assetMainFile, File file) throws IOException, HttpException {
        HttpHelper.MultiPartRequest req = this.getClient().getHttpHelper().createAnypointMultiPartPostRequest("/exchange/api/v1/assets", null);
        req.addText("name", name);
        req.addText("organizationId", this.id);
        req.addText("groupId", this.id);
        req.addText("assetId", assetId);
        req.addText("version", assetVersion);
        req.addText("classifier", assetClassifier);
        req.addText("apiVersion", assetAPIVersion);
        req.addText("main", assetMainFile);
        req.addBinary("asset", new FileStreamSource(file));
        String json = req.execute();
        return this.getClient().getJsonHelper().readJson(new ExchangeAsset(this), json);
    }

    private void publishExchangeAsset(ApplicationIdentifier applicationIdentifier, TempFile newFile) throws IOException {
        MavenHelper.publishArchive(applicationIdentifier, this, (File)newFile);
    }

    public Fabric findFabricByName(String name) throws NotFoundException, HttpException {
        for (Fabric fabric : this.findAllFabric()) {
            if (!fabric.getName().equalsIgnoreCase(name)) continue;
            return fabric;
        }
        throw new NotFoundException("Fabric not found: " + name);
    }

    public List<Fabric> findAllFabric() throws HttpException {
        String json = this.httpHelper.httpGet("/runtimefabric/api/organizations/" + this.id + "/fabrics");
        return this.jsonHelper.readJsonList(Fabric.class, json, this.parent);
    }

    public void promoteExchangeApplication(EnhancedMuleClient emClient, String groupId, String artifactId, String version, String newVersion) throws IOException, NotFoundException {
        if (groupId == null) {
            groupId = this.id;
        }
        boolean snapshotPromotion = false;
        if (newVersion == null) {
            int idx = version.toLowerCase().indexOf("-snapshot");
            if (idx != -1) {
                newVersion = version.substring(0, idx);
                snapshotPromotion = true;
            } else {
                throw new IllegalArgumentException("newVersion not set and version isn't a snapshot");
            }
        }
        try (TempFile file = new TempFile("orig");
             TempFile newFile = new TempFile("new");){
            try (FileOutputStream os = new FileOutputStream((File)file);){
                IOUtils.copy((InputStream)emClient.getExchangeClient().getAsset(groupId, artifactId, version, "mule-application", "jar"), (OutputStream)os);
            }
            ApplicationDescriptor anypointDescriptor = new FileApplicationSource(this.client, (File)file).getAnypointDescriptor(null);
            APIDescriptor apiDescriptor = anypointDescriptor.getApi();
            String snapshotApiVersion = null;
            if (apiDescriptor != null && apiDescriptor.isAssetCreate().booleanValue() && apiDescriptor.getAssetVersion().toLowerCase().contains("-snapshot")) {
                snapshotApiVersion = apiDescriptor.getAssetVersion();
            }
            Unpacker unpacker = new Unpacker((File)file, FileType.ZIP, (File)newFile, FileType.ZIP);
            unpacker.addTransformers(ApplicationArchiveVersionTransformer.getTransformers(new ApplicationIdentifier(groupId, artifactId, version), groupId, newVersion, null));
            unpacker.unpack();
            this.publishExchangeAsset(new ApplicationIdentifier(groupId, artifactId, newVersion), newFile);
            if (snapshotPromotion) {
                String snapshotPrefix = newVersion.toLowerCase() + "-snapshot";
                this.deleteSnapshotAssets(groupId, artifactId, snapshotPrefix);
            }
            if (snapshotApiVersion != null) {
                int idx = snapshotApiVersion.toLowerCase().indexOf("-snapshot");
                snapshotApiVersion = snapshotApiVersion.substring(0, idx + 9);
                this.deleteSnapshotAssets(groupId, apiDescriptor.getAssetId(), snapshotApiVersion);
            }
        }
        catch (UnpackException e) {
            throw new IOException(e);
        }
    }

    private void deleteSnapshotAssets(String groupId, String artifactId, String snapshotPrefix) throws HttpException, NotFoundException {
        ExchangeAsset exchangeAsset = this.findExchangeAsset(groupId, artifactId);
        for (AssetVersion exchangeAssetVersion : exchangeAsset.getVersions()) {
            String v = exchangeAssetVersion.getVersion();
            if (!v.toLowerCase().startsWith(snapshotPrefix)) continue;
            try {
                exchangeAsset.deleteVersion(v);
                eLogger.info(EMTLogger.Product.EXCHANGE, "Deleted exchange asset {} version {}", artifactId, v);
            }
            catch (Exception e) {
                logger.warn("Unable to deleted exchange asset {} version {}: {}", new Object[]{artifactId, v, e.getMessage()});
            }
        }
    }

    public static enum RequestAPIAccessResult {
        GRANTED,
        RESTORED,
        PENDING;

    }
}

