/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.exchange;

import com.aeontronix.commons.URLBuilder;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetVersion;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAssetOverview;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.aeontronix.enhancedmule.tools.util.PaginatedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetList
extends PaginatedList<ExchangeAssetOverview, Organization> {
    private static final Logger logger = LoggerFactory.getLogger(AssetList.class);
    private final String filter;

    public AssetList(Organization org, String filter) throws HttpException {
        this(org, filter, 50);
    }

    public AssetList(Organization org, String filter, int limit) throws HttpException {
        super(org, limit);
        this.filter = filter;
        this.download();
    }

    @Override
    @NotNull
    protected URLBuilder buildUrl() {
        URLBuilder urlBuilder = new URLBuilder("/exchange/api/v1/assets").param("organizationId", ((Organization)this.parent).getId());
        if (this.filter != null) {
            urlBuilder.param("search", this.filter);
        }
        return urlBuilder;
    }

    @Override
    protected void parseJson(String json, JsonHelper jsonHelper) {
        this.list = jsonHelper.readJsonList(ExchangeAssetOverview.class, json, this.parent);
    }

    public List<ExchangeAssetOverview> getAssets() {
        return this.list;
    }

    public void setAssets(List<ExchangeAssetOverview> assetOverviews) {
        this.list = assetOverviews;
    }

    public void delete() throws HttpException {
        for (ExchangeAssetOverview assetOverview : this) {
            for (AssetVersion assetVersion : assetOverview.getAsset().getVersions()) {
                assetVersion.delete();
            }
        }
    }
}

