/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.api;

import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.api.DesignCenterProjectExchange;
import com.aeontronix.enhancedmule.tools.api.LockResult;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;

public class DesignCenterProject
extends AnypointObject<Organization> {
    private String id;
    private String name;
    private String type;
    private String organizationId;

    public DesignCenterProject() {
    }

    public DesignCenterProject(Organization organization) {
        super(organization);
    }

    public static DesignCenterProject create(Organization organization, String name, String type, boolean visualDesignerMode, String ownerId) throws HttpException {
        AnypointClient client = organization.getClient();
        Map<String, Object> req = client.getJsonHelper().buildJsonMap().set("name", name).set("type", type).set("visualDesignerMode", visualDesignerMode).set("environmentId", organization.getId()).set("classifier", type).toMap();
        String json = client.getHttpHelper().anypointHttpPostWithOrgAndOwner("/designcenter/api-designer/projects", req, organization.getId(), client.getUserId());
        return client.getJsonHelper().readJson(new DesignCenterProject(organization), json);
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty
    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public DesignCenterProjectExchange getExchange(String branch) throws HttpException {
        String json = this.client.getHttpHelper().anypointHttpGetWithOrgAndOwner("/designcenter/api-designer/projects/" + this.id + "/branches/" + branch + "/exchange", this.organizationId, this.client.getUserId());
        return this.client.getJsonHelper().readJson(new DesignCenterProjectExchange(this, branch), json);
    }

    public LockResult lock(String branch) throws HttpException {
        String json = this.httpHelper.anypointHttpPostWithOrgAndOwner("/designcenter/api-designer/projects/" + this.id + "/branches/" + branch + "/acquireLock", null, this.organizationId, this.client.getUserId());
        return this.client.getJsonHelper().readJson(new LockResult(), json);
    }

    public LockResult unlock(String branch) throws HttpException {
        String json = this.httpHelper.anypointHttpPostWithOrgAndOwner("/designcenter/api-designer/projects/" + this.id + "/branches/" + branch + "/releaseLock", null, this.organizationId, this.client.getUserId());
        return this.client.getJsonHelper().readJson(new LockResult(), json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishExchange(String branch, String assetId, String name, String mainFile, String assetVersion, String apiVersion) throws HttpException {
        Map<String, Object> req = this.jsonHelper.buildJsonMap().set("name", name).set("apiVersion", apiVersion).set("version", assetVersion).set("main", mainFile).set("assetId", assetId).set("groupId", this.organizationId).set("classifier", this.type).set("isVisual", false).set("tags", Collections.emptyList()).toMap();
        this.lock(branch);
        try {
            String string = this.httpHelper.anypointHttpPostWithOrgAndOwner("/designcenter/api-designer/projects/" + this.id + "/branches/" + branch + "/publish/exchange", req, this.organizationId, this.client.getUserId());
        }
        finally {
            this.unlock(branch);
        }
    }
}

