/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.application;

import com.aeontronix.commons.Required;
import com.aeontronix.commons.xml.XmlUtils;
import com.aeontronix.enhancedmule.tools.application.ApplicationIdentifier;
import com.aeontronix.enhancedmule.tools.application.MavenHelper;
import com.aeontronix.enhancedmule.tools.provisioning.ApplicationDescriptor;
import com.aeontronix.unpack.transformer.JacksonTransformer;
import com.aeontronix.unpack.transformer.RenameTransformer;
import com.aeontronix.unpack.transformer.SetPropertyTransformer;
import com.aeontronix.unpack.transformer.Transformer;
import com.aeontronix.unpack.transformer.XMLTransformer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ApplicationArchiveVersionTransformer {
    private final ApplicationIdentifier appId;
    private final String orgId;
    private final String newVersion;
    private ApplicationDescriptor anypointDescriptor;
    private String snapshotTimestamp;

    public ApplicationArchiveVersionTransformer(ApplicationIdentifier appId, String orgId, String newVersion, String snapshotTimestamp) {
        this.appId = appId;
        this.orgId = orgId;
        this.newVersion = newVersion;
        this.snapshotTimestamp = snapshotTimestamp;
    }

    public static List<Transformer> getTransformers(final ApplicationIdentifier appId, final String orgId, final String newVersion, final String snapshotTimestamp) {
        String pomPath = MavenHelper.pomPath(appId, appId.getGroupId());
        String pomPropsPath = MavenHelper.mavenMetaPath(appId, appId.getGroupId(), "pom.properties");
        HashMap<String, String> pomProps = new HashMap<String, String>();
        pomProps.put("groupId", orgId);
        if (newVersion != null) {
            pomProps.put("version", newVersion);
        }
        return Arrays.asList(new XMLTransformer(pomPath, Required.REQUIRED, false, true){

            public void transform(Document document) throws Exception {
                Element project = XmlUtils.getChildElement((Node)document, (String)"project", (boolean)false);
                XmlUtils.getChildElement((Node)project, (String)"groupId", (boolean)true).setTextContent(orgId);
                if (newVersion != null) {
                    XmlUtils.getChildElement((Node)project, (String)"version", (boolean)true).setTextContent(newVersion);
                }
            }
        }, new SetPropertyTransformer(pomPropsPath, Required.REQUIRED, pomProps), new RenameTransformer("META-INF/maven/" + appId.getGroupId() + "/", "META-INF/maven/" + orgId + "/", true), new RenameTransformer("META-INF/maven/" + appId.getGroupId() + "/" + appId.getArtifactId() + "/", "META-INF/maven/" + orgId + "/" + appId.getArtifactId() + "/", true), new RenameTransformer(pomPath, MavenHelper.mavenMetaPath(appId, orgId, "pom.xml")), new RenameTransformer(pomPropsPath, MavenHelper.mavenMetaPath(appId, orgId, "pom.properties")), new JacksonTransformer<ObjectNode>("anypoint.json", Required.OPTIONAL, ObjectNode.class){

            public JsonNode transform(ObjectNode root) throws Exception {
                JsonNode assetVersion;
                ObjectNode api;
                if (newVersion != null) {
                    root.put("version", newVersion);
                }
                if ((api = (ObjectNode)root.get("api")) != null && (assetVersion = api.get("assetVersion")) != null && assetVersion.textValue().toLowerCase().contains("-snapshot")) {
                    api.put("assetVersion", assetVersion.textValue() + "-" + snapshotTimestamp);
                }
                return root;
            }
        }, new JacksonTransformer<ObjectNode>("META-INF/mule-artifact/classloader-model.json", Required.REQUIRED, ObjectNode.class){

            public JsonNode transform(ObjectNode root) throws Exception {
                ObjectNode artifactCoordinates = this.getObject(root, "artifactCoordinates", true);
                artifactCoordinates.put("groupId", orgId);
                if (newVersion != null) {
                    artifactCoordinates.put("version", newVersion);
                }
                return root;
            }
        }, new JacksonTransformer<ObjectNode>("META-INF/mule-artifact/mule-artifact.json", Required.REQUIRED, ObjectNode.class){

            public JsonNode transform(ObjectNode root) throws Exception {
                root.put("name", orgId + ":" + appId.getArtifactId() + ":" + newVersion);
                return root;
            }
        });
    }
}

