/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.application;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.TempFile;
import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.UnexpectedException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.application.ApplicationArchiveVersionTransformer;
import com.aeontronix.enhancedmule.tools.application.ApplicationIdentifier;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.unpack.FileType;
import com.aeontronix.unpack.UnpackException;
import com.aeontronix.unpack.Unpacker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenHelper {
    private static final Logger logger = LoggerFactory.getLogger(MavenHelper.class);

    public static ApplicationIdentifier uploadToMaven(ApplicationIdentifier appId, Organization org, ApplicationSource applicationSource, String newVersion, String buildNumber) throws IOException, UnpackException {
        ApplicationIdentifier newAppId;
        File appArchFile = applicationSource.getLocalFile();
        if (appId == null) {
            try (ZipFile zipFile = new ZipFile(appArchFile);){
                appId = MavenHelper.getApplicationIdentifier(org, zipFile);
            }
        }
        if (newVersion == null && appId.getVersion().toLowerCase().endsWith("-snapshot")) {
            newVersion = appId.getVersion() + "-" + buildNumber;
            newAppId = new ApplicationIdentifier(org.getId(), appId.getArtifactId(), newVersion);
            logger.info("Snapshot version = " + newVersion);
        } else {
            newAppId = new ApplicationIdentifier(org.getId(), appId.getArtifactId(), appId.getVersion());
        }
        if (!org.getId().equals(appId.getGroupId()) || newVersion != null) {
            try (TempFile emteh = new TempFile("emteh");){
                Unpacker unpacker = new Unpacker(appArchFile, FileType.ZIP, (File)emteh, FileType.ZIP);
                unpacker.addTransformers(ApplicationArchiveVersionTransformer.getTransformers(appId, org.getId(), newVersion, buildNumber));
                unpacker.unpack();
                MavenHelper.publishArchive(newAppId, org, (File)emteh);
            }
        } else {
            MavenHelper.publishArchive(newAppId, org, appArchFile);
        }
        return new ApplicationIdentifier(org.getId(), appId.getArtifactId(), newVersion != null ? newVersion : appId.getVersion());
    }

    public static void publishArchive(ApplicationIdentifier appId, Organization org, File appArchFile) throws IOException {
        try (ZipFile zipFile = new ZipFile(appArchFile);){
            MavenHelper.publishFile(org, appId, zipFile, MavenHelper.pomPath(appId, org.getId()), ".pom");
            logger.debug("Uploaded POM");
            MavenHelper.publishFile(org, appId, zipFile, "anypoint.json", "-anypoint-descriptor.json");
            logger.debug("Uploaded anypoint.json");
        }
        try (FileInputStream is = new FileInputStream(appArchFile);){
            org.getClient().getHttpHelper().httpPutBasicAuth(MavenHelper.createMavenUrl(org, appId).path(appId.getArtifactId() + "-" + appId.getVersion() + "-mule-application.jar").toString(), is, null);
            logger.debug("Uploaded Application");
        }
    }

    @NotNull
    public static String pomPath(ApplicationIdentifier appId, String orgId) {
        return MavenHelper.mavenMetaPath(appId, orgId, "pom.xml");
    }

    @NotNull
    public static String mavenMetaPath(ApplicationIdentifier appId, String orgId, String file) {
        return "META-INF/maven/" + orgId + "/" + appId.getArtifactId() + "/" + file;
    }

    private static ApplicationIdentifier getApplicationIdentifier(Organization org, ZipFile zipFile) throws IOException {
        Map classloaderModel = (Map)org.getClient().getJsonHelper().getJsonMapper().readValue(zipFile.getInputStream(zipFile.getEntry("META-INF/mule-artifact/classloader-model.json")), Map.class);
        Map artifactCoordinates = (Map)classloaderModel.get("artifactCoordinates");
        if (artifactCoordinates == null) {
            throw new UnexpectedException("Invalid classloader-model.json: artifactCoordinates missing");
        }
        String groupId = (String)artifactCoordinates.get("groupId");
        String artifactId = (String)artifactCoordinates.get("artifactId");
        String version = (String)artifactCoordinates.get("version");
        if (StringUtils.isBlank((String)groupId) || StringUtils.isBlank((String)artifactId) || StringUtils.isBlank((String)version)) {
            throw new UnexpectedException("Invalid classloader-model.json: groupId or artifactId missing");
        }
        return new ApplicationIdentifier(groupId, artifactId, version);
    }

    private static void publishFile(Organization org, ApplicationIdentifier appId, ZipFile zipFile, String path, String ext) throws IOException {
        try (InputStream pomData = zipFile.getInputStream(zipFile.getEntry(path));){
            org.getClient().getHttpHelper().httpPutBasicAuth(MavenHelper.createMavenUrl(org, appId).path(appId.getArtifactId() + "-" + appId.getVersion() + ext).toString(), pomData, null);
        }
    }

    private static URLBuilder createMavenUrl(Organization org, ApplicationIdentifier appId) {
        return new URLBuilder("https://maven.anypoint.mulesoft.com/api/v2/maven").path(org.getId(), true).path(appId.getArtifactId(), true).path(appId.getVersion(), true);
    }
}

