/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.config;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.config.ConfigProfile;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class ConfigFile
extends ConfigProfile {
    @JsonProperty(value="default")
    private String defaultProfile;
    @JsonProperty(value="profiles")
    private Map<String, ConfigProfile> profiles;

    public static ConfigProfile findConfigProfile(String org, String profile) throws IOException {
        ConfigFile configFile = ConfigFile.findConfigFile();
        if (configFile != null) {
            if (StringUtils.isNotBlank((String)profile)) {
                ConfigProfile p = configFile.getProfile(profile);
                if (p != null) {
                    return p;
                }
                throw new IOException("Profile not found: " + profile);
            }
            return configFile.getMatchingProfile(org);
        }
        return null;
    }

    public static ConfigFile findConfigFile() throws IOException {
        return ConfigFile.findConfigFile(null);
    }

    public static ConfigFile findConfigFile(String filename) throws IOException {
        InputStream is;
        block3: {
            ConfigFile configFile;
            if (filename == null) {
                filename = "enhanced-mule.config.json";
            }
            is = null;
            try {
                is = ConfigFile.findConfig(filename);
                if (is == null) break block3;
                configFile = (ConfigFile)new ObjectMapper().readValue(is, ConfigFile.class);
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{is});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{is});
            return configFile;
        }
        IOUtils.close((Closeable[])new Closeable[]{is});
        return null;
    }

    private static InputStream findConfig(String filename) throws FileNotFoundException {
        File file = new File(filename);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        file = new File(System.getProperty("user.home") + File.separatorChar + "." + filename);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        file = new File(System.getProperty("user.home") + File.separatorChar + ".enhanced-mule" + File.separatorChar + filename);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        InputStream is = ConfigFile.class.getClassLoader().getResourceAsStream(filename);
        if (is != null) {
            return is;
        }
        is = ConfigFile.class.getClassLoader().getResourceAsStream("/" + filename);
        if (is != null) {
            return is;
        }
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        if (is != null) {
            return is;
        }
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/" + filename);
        return is;
    }

    private ConfigProfile getProfile(String profile) {
        return profile != null ? this.profiles.get(profile) : null;
    }

    public ConfigProfile getMatchingProfile(String org) {
        if (this.profiles == null) {
            return this;
        }
        if (StringUtils.isNotBlank((String)org)) {
            for (ConfigProfile p : this.profiles.values()) {
                if (p.getOrgs() == null) continue;
                for (String profileOrg : p.getOrgs()) {
                    if (!org.equalsIgnoreCase(profileOrg)) continue;
                    return p;
                }
            }
        }
        if (this.defaultProfile != null) {
            return this.profiles.get(this.defaultProfile);
        }
        return null;
    }

    public String getDefaultProfile() {
        return this.defaultProfile;
    }

    public void setDefaultProfile(String defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    public Map<String, ConfigProfile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Map<String, ConfigProfile> profiles) {
        this.profiles = profiles;
    }
}

