/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.legacy.deploy;

import com.aeontronix.commons.FileUtils;
import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.UnexpectedException;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ExchangeDeployDescriptor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;

public class ApplicationDeployerScriptBuilder {
    public static final String MVN_WRAPPER_PREFIX = ".mvn/wrapper/";
    public static final String MVNW = "mvnw";
    public static final String MVNW_CMD = "mvnw.cmd";
    public static final String DEFAULT_MVN_OPTIONS = "-B -ntp -e";
    private String version;
    private boolean mvnWrapper;
    private String groupId;
    private String artifactId;
    private String emtVersion;
    private String mvnOptions = "-B -ntp -e";
    private File mavenWrapperDir;

    public ApplicationDeployerScriptBuilder(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        try {
            InputStream pomProps = this.getClass().getResourceAsStream("/META-INF/maven/com.aeontronix.enhanced-mule/enhanced-mule-tools-lib/pom.properties");
            if (pomProps != null) {
                Properties emtRel = new Properties();
                emtRel.load(pomProps);
                this.emtVersion = emtRel.getProperty("version");
            }
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public ApplicationDeployerScriptBuilder withMvnWrapper(boolean mvnWrapper) {
        this.mvnWrapper = mvnWrapper;
        return this;
    }

    public ApplicationDeployerScriptBuilder withMvnWrapperDir(File mavenWrapperDir) {
        this.mavenWrapperDir = mavenWrapperDir;
        this.mvnWrapper = new File(mavenWrapperDir, MVNW).exists() || new File(mavenWrapperDir, MVNW_CMD).exists();
        return this;
    }

    public ApplicationDeployerScriptBuilder withEMTVersion(String emtVersion) {
        if (emtVersion != null) {
            this.emtVersion = emtVersion;
        }
        return this;
    }

    public ApplicationDeployerScriptBuilder withMvnOptions(String mvnOptions) {
        this.mvnOptions = mvnOptions;
        return this;
    }

    public void buildZipArchive(File zipFile) throws IOException {
        if (zipFile.exists()) {
            FileUtils.delete((File[])new File[]{zipFile});
        }
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            if (this.mavenWrapperDir != null) {
                this.copyFileToZip(zos, "", MVNW, this.mavenWrapperDir);
                this.copyFileToZip(zos, "", MVNW_CMD, this.mavenWrapperDir);
                File mvnWrapperDir = new File(this.mavenWrapperDir + File.separator + ".mvn" + File.separator + "wrapper");
                this.copyFileToZip(zos, MVN_WRAPPER_PREFIX, "maven-wrapper.properties", mvnWrapperDir);
                this.copyFileToZip(zos, MVN_WRAPPER_PREFIX, "MavenWrapperDownloader.java", mvnWrapperDir);
            }
            this.writeFileToZip(zos, "deploy.sh", this.buildUnix());
            this.writeFileToZip(zos, "deploy.cmd", this.buildWin());
            this.writeFileToZip(zos, "deploy.json", this.buildJsonDescriptor());
            this.writeFileToZip(zos, "deploy.ps1", "start -wait -NoNewWindow '.\\deploy.cmd' -args \"$args\"");
        }
    }

    public String buildJsonDescriptor() {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString((Object)new ExchangeDeployDescriptor(this.groupId, this.artifactId, this.version));
        }
        catch (JsonProcessingException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public String buildUnix() {
        try {
            String script = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/deployer-unix.sh"));
            return this.replaceVars(script, "sh mvnw");
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public String buildWin() {
        try {
            String script = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/deployer-win.bat"));
            return this.replaceVars(script, MVNW_CMD);
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    @NotNull
    private String replaceVars(String script, String wrapperScript) {
        script = script.replace("@MVN_CMD@", this.mvnWrapper ? wrapperScript : "mvn");
        script = script.replace("@GROUP_ID@", this.groupId);
        script = script.replace("@ARTIFACT_ID@", this.artifactId);
        script = script.replace("@VERSION@", this.version);
        script = script.replace("@MVN_OPTS@", this.mvnOptions);
        if (this.emtVersion == null) {
            throw new IllegalStateException("No EMT version found");
        }
        script = script.replace("@EMT_VERSION@", this.emtVersion);
        return script;
    }

    private void writeFileToZip(ZipOutputStream zipFile, String path, String content) throws IOException {
        ZipEntry e = new ZipEntry(path);
        zipFile.putNextEntry(e);
        zipFile.write(StringUtils.utf8((String)content));
        zipFile.closeEntry();
    }

    private void copyFileToZip(ZipOutputStream zipFile, String prefix, String filename, File projectBasedir) throws IOException {
        File file = new File(projectBasedir, filename);
        if (file.exists()) {
            ZipEntry e = new ZipEntry(prefix + file.getName());
            zipFile.putNextEntry(e);
            try (FileInputStream fis = new FileInputStream(file);){
                IOUtils.copy((InputStream)fis, (OutputStream)zipFile);
            }
            zipFile.closeEntry();
        }
    }
}

