/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.legacy.deploy;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.TempFile;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ExchangeApplicationSource;
import com.aeontronix.enhancedmule.tools.legacy.deploy.FileApplicationSource;
import com.aeontronix.enhancedmule.tools.provisioning.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningConfig;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationSource
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationSource.class);
    protected AnypointClient client;

    public ApplicationSource(AnypointClient client) {
        this.client = client;
    }

    public abstract String getFileName();

    public abstract File getLocalFile() throws IOException;

    public abstract boolean exists();

    public abstract ApplicationDescriptor getAnypointDescriptor(APIProvisioningConfig var1) throws IOException, HttpException;

    @Nullable
    protected ApplicationDescriptor readDescriptorFromZip(File file, APIProvisioningConfig apiProvisioningConfig) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        ZipEntry anypointJson = zipFile.getEntry("anypoint.json");
        if (anypointJson != null) {
            try (InputStream is = zipFile.getInputStream(anypointJson);){
                if (apiProvisioningConfig != null) {
                    ApplicationDescriptor applicationDescriptor = ApplicationDescriptor.read(apiProvisioningConfig, is);
                    return applicationDescriptor;
                }
                ApplicationDescriptor applicationDescriptor = this.client.getJsonHelper().readJson(new ApplicationDescriptor(), IOUtils.toString((InputStream)is));
                return applicationDescriptor;
            }
        }
        return null;
    }

    public abstract String getArtifactId();

    public static ApplicationSource create(String orgId, AnypointClient client, String path) throws IOException {
        if (path.startsWith("exchange://")) {
            return new ExchangeApplicationSource(orgId, client, path);
        }
        return new FileApplicationSource(client, new File(path));
    }

    public abstract Map<String, Object> getSourceJson(JsonHelper var1);

    public void copyAPISpecs(String assetMainFile, TempFile apiSpecFile) throws IOException {
        try (ZipOutputStream os = new ZipOutputStream(new FileOutputStream((File)apiSpecFile));){
            ZipFile zipFile = new ZipFile(this.getLocalFile());
            if (zipFile.getEntry("api/" + assetMainFile) == null) {
                throw new IOException("asset main file not found: " + assetMainFile);
            }
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry zipEntry = entries.nextElement();
                if (!zipEntry.getName().toLowerCase().startsWith("api/") || !StringUtils.isNotBlank((String)(name = zipEntry.getName().substring(4)))) continue;
                os.putNextEntry(new ZipEntry(name));
                IOUtils.copy((InputStream)zipFile.getInputStream(zipEntry), (OutputStream)os);
                os.closeEntry();
            }
        }
    }
}

