/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.legacy.deploy;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.cloudhub.CHMuleVersion;
import com.aeontronix.enhancedmule.tools.cloudhub.CHWorkerType;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.legacy.deploy.Deployer;
import com.aeontronix.enhancedmule.tools.legacy.deploy.DeploymentConfig;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningConfig;
import com.aeontronix.enhancedmule.tools.runtime.CHApplication;
import com.aeontronix.enhancedmule.tools.runtime.CHDeploymentResult;
import com.aeontronix.enhancedmule.tools.runtime.DeploymentResult;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.HttpHelper;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.aeontronix.enhancedmule.tools.util.StreamSource;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHDeployer
extends Deployer {
    private static final Logger logger = LoggerFactory.getLogger(CHDeployer.class);
    private static final EMTLogger elogger = new EMTLogger(logger);
    private int workerCount;
    private CHMuleVersion muleVersion;
    private String region;
    private CHWorkerType workerType;

    public CHDeployer() {
    }

    public CHDeployer(String muleVersionName, String regionName, String workerTypeName, int workerCount, Environment environment, String appName, ApplicationSource file, String filename, APIProvisioningConfig apiProvisioningConfig, DeploymentConfig deploymentConfig) throws HttpException, NotFoundException {
        super(environment, appName, file, filename, apiProvisioningConfig, deploymentConfig);
        this.workerCount = workerCount;
        this.muleVersion = StringUtils.isBlank((String)muleVersionName) ? environment.findDefaultCHMuleVersion() : environment.findCHMuleVersion(muleVersionName);
        this.region = StringUtils.isBlank((String)regionName) ? environment.findDefaultCHRegion().getId() : regionName;
        this.workerType = StringUtils.isBlank((String)workerTypeName) ? environment.findSmallestWorkerType() : environment.findWorkerTypeByName(workerTypeName);
    }

    @Override
    protected DeploymentResult doDeploy() throws IOException, HttpException {
        String deploymentJson;
        long start = System.currentTimeMillis();
        AnypointClient client = this.environment.getClient();
        HttpHelper httpHelper = client.getHttpHelper();
        JsonHelper.MapBuilder appInfoBuilder = client.getJsonHelper().buildJsonMap();
        if (this.deploymentConfig.isExtMonitoring()) {
            this.deploymentConfig.setProperty("anypoint.platform.config.analytics.agent.enabled", "true");
        }
        CHApplication existingApp = this.getExistingApp(this.appName);
        this.deploymentConfig.mergeExistingProperties(existingApp);
        appInfoBuilder.set("properties", this.deploymentConfig.getProperties()).set("domain", this.appName).set("monitoringEnabled", true).set("monitoringAutoRestart", true).set("loggingNgEnabled", true).set("objectStoreV1", this.deploymentConfig.isObjectStoreV1()).set("persistentQueues", this.deploymentConfig.isPersistentQueues()).set("persistentQueuesEncrypted", this.deploymentConfig.isPersistentQueuesEncrypted()).set("staticIPsEnabled", this.deploymentConfig.isStaticIPs()).set("loggingCustomLog4JEnabled", this.deploymentConfig.isCustomlog4j());
        appInfoBuilder.addMap("muleVersion").set("version", this.muleVersion.getVersion()).set("updateId", this.muleVersion.getLatestUpdate().getId());
        appInfoBuilder.addMap("workers").set("amount", this.workerCount).addMap("type").set("name", this.workerType.getName()).set("weight", this.workerType.getWeight()).set("cpu", this.workerType.getCpu()).set("memory", this.workerType.getMemory());
        appInfoBuilder.set("fileName", this.filename);
        Map<String, Object> appInfo = appInfoBuilder.toMap();
        logger.debug("Deploying application");
        if (this.source.getLocalFile() != null) {
            HttpHelper.MultiPartRequest req;
            if (existingApp != null) {
                req = httpHelper.createAnypointMultiPartPutRequest("/cloudhub/api/v2/applications/" + existingApp.getDomain(), this.environment);
            } else {
                req = httpHelper.createAnypointMultiPartPostRequest("/cloudhub/api/v2/applications", this.getEnvironment());
                req = req.addText("autoStart", "true");
            }
            String appInfoJson = new String(this.environment.getClient().getJsonHelper().toJson(appInfo));
            req = req.addText("appInfoJson", appInfoJson);
            logger.debug("Deployment JSON: {}", (Object)appInfoJson);
            req = req.addBinary("file", new StreamSource(){

                @Override
                public String getFileName() {
                    return CHDeployer.this.filename;
                }

                @Override
                public InputStream createInputStream() throws IOException {
                    return new FileInputStream(CHDeployer.this.source.getLocalFile());
                }
            });
            elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Uploading application archive to Cloudhub", new Object[0]);
            deploymentJson = req.execute();
            elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Application starting", new Object[0]);
        } else {
            HashMap<String, Object> deployJson = new HashMap<String, Object>();
            deployJson.put("applicationInfo", appInfo);
            deployJson.put("applicationSource", this.source.getSourceJson(client.getJsonHelper()));
            if (existingApp != null) {
                deploymentJson = httpHelper.anypointHttpPut("/cloudhub/api/v2/applications/" + existingApp.getDomain(), deployJson, this.environment);
            } else {
                deployJson.put("autoStart", true);
                deploymentJson = httpHelper.anypointHttpPost("/cloudhub/api/v2/applications/", deployJson, this.environment);
            }
            elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Requested application start from exchange asset", new Object[0]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("File upload took " + TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start) + " seconds");
        }
        if (!(existingApp == null || existingApp.getStatus().equalsIgnoreCase("STARTED") && existingApp.getDeploymentUpdateStatus() == null)) {
            try {
                existingApp.start();
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return new CHDeploymentResult(client.getJsonHelper().readJson(new CHApplication(), deploymentJson, this.environment));
    }

    private CHApplication getExistingApp(String appName) throws HttpException {
        try {
            logger.debug("Searching for pre-existing application named " + appName);
            CHApplication application = this.environment.findCHApplicationByDomain(appName);
            logger.debug("Found application named {}", (Object)appName);
            return application;
        }
        catch (NotFoundException e) {
            logger.debug("Couldn't find application named {}", (Object)appName);
            return null;
        }
    }
}

