/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.legacy.deploy;

import com.aeontronix.commons.Required;
import com.aeontronix.commons.TempFile;
import com.aeontronix.commons.UnexpectedException;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.api.ClientApplication;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.legacy.deploy.DeploymentConfig;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ExchangeApplicationSource;
import com.aeontronix.enhancedmule.tools.legacy.deploy.FileApplicationSource;
import com.aeontronix.enhancedmule.tools.provisioning.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.ProvisioningException;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningConfig;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningResult;
import com.aeontronix.enhancedmule.tools.provisioning.api.ClientApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.PropertyDescriptor;
import com.aeontronix.enhancedmule.tools.runtime.DeploymentResult;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.HttpHelper;
import com.aeontronix.unpack.FileType;
import com.aeontronix.unpack.Unpacker;
import com.aeontronix.unpack.transformer.SetPropertyTransformer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Deployer {
    private static final Logger logger = LoggerFactory.getLogger(Deployer.class);
    private static final EMTLogger elogger = new EMTLogger(logger);
    public static final String ANYPOINT_PLATFORM_CLIENT_ID = "anypoint.platform.client_id";
    public static final String ANYPOINT_PLATFORM_CLIENT_SECRET = "anypoint.platform.client_secret";
    protected Environment environment;
    protected String appName;
    protected ApplicationSource source;
    protected String filename;
    protected APIProvisioningConfig apiProvisioningConfig;
    protected DeploymentConfig deploymentConfig;
    protected ApplicationDescriptor applicationDescriptor;

    public Deployer() {
    }

    public Deployer(Environment environment, String appName, ApplicationSource source, String filename, APIProvisioningConfig apiProvisioningConfig, @NotNull DeploymentConfig deploymentConfig) {
        this.environment = environment;
        this.appName = appName;
        this.source = source;
        this.filename = filename;
        this.apiProvisioningConfig = apiProvisioningConfig;
        this.deploymentConfig = deploymentConfig;
    }

    public DeploymentResult deploy() throws ProvisioningException, IOException, HttpException {
        DeploymentResult deploymentResult;
        block28: {
            AnypointClient client = this.environment.getClient();
            boolean tmpFile = false;
            try {
                Map<String, String> fileProperties;
                this.environment = this.environment.refresh();
                APIProvisioningResult provisioningResult = null;
                ArrayList<SetPropertyTransformer> transformers = new ArrayList<SetPropertyTransformer>();
                if (this.apiProvisioningConfig != null) {
                    this.applicationDescriptor = this.source.getAnypointDescriptor(this.apiProvisioningConfig);
                    if (this.applicationDescriptor != null) {
                        block27: {
                            logger.debug("Found anypoint provisioning file, provisioning");
                            provisioningResult = this.applicationDescriptor.provision(this.environment, this.apiProvisioningConfig, this.source);
                            APIDescriptor apiDescriptor = this.applicationDescriptor.getApi();
                            if (provisioningResult.getApi() != null && apiDescriptor.isInjectApiId()) {
                                String deploymentResult2 = apiDescriptor.getApiIdProperty();
                                if (deploymentResult2 == null) {
                                    throw new IllegalArgumentException("apiIdProperty musn't be null");
                                }
                                this.deploymentConfig.setOverrideProperty(deploymentResult2, provisioningResult.getApi().getId());
                                this.deploymentConfig.setOverrideProperty(ANYPOINT_PLATFORM_CLIENT_ID, this.environment.getClientId());
                                try {
                                    String string = this.environment.getClientSecret();
                                    if (string != null) {
                                        this.deploymentConfig.setOverrideProperty(ANYPOINT_PLATFORM_CLIENT_SECRET, string);
                                    }
                                }
                                catch (HttpException httpException) {
                                    if (httpException.getStatusCode() == 401) break block27;
                                    throw httpException;
                                }
                            }
                        }
                        ClientApplicationDescriptor clientApplicationDescriptor = this.applicationDescriptor.getClient();
                        ClientApplication clientApplication = provisioningResult.getClientApplication();
                        if (clientApplication != null && clientApplicationDescriptor != null && clientApplicationDescriptor.isInjectClientIdSec()) {
                            String clientIdProperty = clientApplicationDescriptor.getClientIdProperty();
                            if (clientIdProperty == null) {
                                throw new IllegalStateException("client descriptor id property musn't be null");
                            }
                            this.deploymentConfig.setOverrideProperty(clientIdProperty, clientApplication.getClientId());
                            String clientSecretProperty = clientApplicationDescriptor.getClientSecretProperty();
                            if (clientSecretProperty == null) {
                                throw new IllegalStateException("client descriptor id property musn't be null");
                            }
                            this.deploymentConfig.setOverrideProperty(clientSecretProperty, clientApplication.getClientSecret());
                        }
                    } else {
                        logger.info("no anypoint.json found, skipping provisioning");
                    }
                }
                if (this.deploymentConfig.isFilePropertiesSecure() && this.applicationDescriptor.getProperties() != null) {
                    for (PropertyDescriptor propertyDescriptor : this.applicationDescriptor.getProperties().values()) {
                        if (!propertyDescriptor.isSecure()) continue;
                        String string = this.deploymentConfig.getProperties().remove(propertyDescriptor.getKey());
                        this.deploymentConfig.addFileProperty(propertyDescriptor.getKey(), string);
                    }
                }
                if ((fileProperties = this.deploymentConfig.getFileProperties()) != null && !fileProperties.isEmpty()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("File properties injected into application: {}", fileProperties);
                        for (Map.Entry<String, String> entry : fileProperties.entrySet()) {
                            logger.debug("> {} = {}", (Object)entry.getKey(), (Object)entry.getValue());
                        }
                        logger.debug("filePropertiesPath= {}", (Object)this.deploymentConfig.getFilePropertiesPath());
                    }
                    transformers.add(new SetPropertyTransformer(this.deploymentConfig.getFilePropertiesPath(), Required.CREATE, new HashMap<String, String>(fileProperties)));
                    logger.info("Added properties file to application archive");
                }
                if (!transformers.isEmpty()) {
                    try {
                        if (this.source instanceof FileApplicationSource || this.source.getLocalFile() != null) {
                            File file = this.source.getLocalFile();
                            TempFile tempFile = new TempFile("transformed", this.filename);
                            this.source = new FileApplicationSource(client, (File)tempFile);
                            Unpacker unpacker = new Unpacker(file, FileType.ZIP, (File)tempFile, FileType.ZIP);
                            unpacker.addTransformers(transformers);
                            unpacker.unpack();
                            logger.info("Enhanced application archive");
                        } else if (this.source instanceof ExchangeApplicationSource) {
                            throw new ProvisioningException("Transformations on exchange sources not supported at this (so OnPrem provisioned deployments won't work with exchange sources until this feature is added)");
                        }
                    }
                    catch (Exception exception) {
                        throw new ProvisioningException("An error occurred while applying application " + this.appName + " transformations: " + exception.getMessage(), exception);
                    }
                    tmpFile = true;
                }
                deploymentResult = this.doDeploy();
                if (!tmpFile) break block28;
            }
            catch (NotFoundException e) {
                try {
                    throw new UnexpectedException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpFile) {
                        IOUtils.close((Closeable[])new Closeable[]{(TempFile)this.source.getLocalFile()});
                    }
                    throw throwable;
                }
            }
            IOUtils.close((Closeable[])new Closeable[]{(TempFile)this.source.getLocalFile()});
        }
        return deploymentResult;
    }

    protected abstract DeploymentResult doDeploy() throws IOException, HttpException;

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public ApplicationSource getSource() {
        return this.source;
    }

    public void setSource(ApplicationSource source) {
        this.source = source;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    protected String executeRequest(long start, HttpHelper.MultiPartRequest multiPartRequest) throws HttpException, IOException {
        String json = multiPartRequest.execute();
        if (logger.isDebugEnabled()) {
            logger.debug("File upload took " + TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start) + " seconds");
        }
        return json;
    }
}

