/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.legacy.deploy;

import com.aeontronix.commons.TempFile;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.provisioning.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningConfig;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeApplicationSource
extends ApplicationSource {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeApplicationSource.class);
    public static final String PREFIX = "exchange://";
    private ApplicationDescriptor apiProvisioningDescriptor;
    private String orgId;
    private String groupId;
    private String artifactId;
    private String version;
    private TempFile tempFile;

    ExchangeApplicationSource(String orgId, AnypointClient client, String url) throws IllegalArgumentException, IOException {
        super(client);
        if (!url.startsWith(PREFIX)) {
            throw new IllegalArgumentException("Invalid exchange url ( must start with exchange:// ): " + url);
        }
        String[] els = url.substring(PREFIX.length()).split(":");
        if (els.length < 2 || els.length > 4) {
            throw new IllegalArgumentException("Invalid exchange url: " + url);
        }
        if (els.length == 2) {
            this.groupId = this.orgId = orgId;
            this.artifactId = els[0];
            this.version = els[1];
        } else if (els.length == 3) {
            this.groupId = this.orgId = els[0];
            this.artifactId = els[1];
            this.version = els[2];
        } else {
            this.orgId = els[0];
            this.groupId = els[1];
            this.artifactId = els[2];
            this.version = els[3];
        }
    }

    public ExchangeApplicationSource(AnypointClient client, String orgId, String groupId, String artifactId, String version) {
        super(client);
        this.client = client;
        this.orgId = orgId;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getFileName() {
        return this.artifactId + "-" + this.version;
    }

    @Override
    public File getLocalFile() throws IOException {
        if (this.tempFile == null) {
            this.tempFile = new TempFile("anyp-apparch");
            try (FileOutputStream fos = new FileOutputStream((File)this.tempFile);){
                this.client.getHttpHelper().httpGetBasicAuth("https://maven.anypoint.mulesoft.com/api/v2/maven/" + this.groupId + "/" + this.artifactId + "/" + this.version + "/" + this.artifactId + "-" + this.version + "-mule-application.jar", fos);
            }
        }
        return this.tempFile;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public ApplicationDescriptor getAnypointDescriptor(APIProvisioningConfig apiProvisioningConfig) throws IOException, HttpException {
        block3: {
            if (this.apiProvisioningDescriptor == null) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                try {
                    this.client.getHttpHelper().httpGetBasicAuth("https://maven.anypoint.mulesoft.com/api/v2/maven/" + this.groupId + "/" + this.artifactId + "/" + this.version + "/" + this.artifactId + "-" + this.version + "-anypoint-descriptor.json", buf);
                    buf.close();
                    this.apiProvisioningDescriptor = this.client.getJsonHelper().readJson(new ApplicationDescriptor(), new String(buf.toByteArray()));
                }
                catch (HttpException e) {
                    if (e.getStatusCode() == 404) break block3;
                    throw e;
                }
            }
        }
        return this.apiProvisioningDescriptor;
    }

    @Override
    public Map<String, Object> getSourceJson(JsonHelper jsonHelper) {
        return jsonHelper.buildJsonMap().set("source", "EXCHANGE").set("groupId", this.groupId).set("artifactId", this.artifactId).set("version", this.version).set("organizationId", this.orgId).toMap();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.tempFile});
    }
}

