/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.legacy.deploy;

import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.legacy.deploy.Deployer;
import com.aeontronix.enhancedmule.tools.legacy.deploy.DeploymentConfig;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningConfig;
import com.aeontronix.enhancedmule.tools.runtime.DeploymentResult;
import com.aeontronix.enhancedmule.tools.runtime.HApplication;
import com.aeontronix.enhancedmule.tools.runtime.HDeploymentResult;
import com.aeontronix.enhancedmule.tools.runtime.Server;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.HttpHelper;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.aeontronix.enhancedmule.tools.util.StreamSource;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDeployer
extends Deployer {
    private static final Logger logger = LoggerFactory.getLogger(HDeployer.class);
    private static final EMTLogger elogger = new EMTLogger(logger);
    private Server target;
    private JsonHelper jsonHelper;

    public HDeployer(Server target, String appName, ApplicationSource file, String filename, @NotNull APIProvisioningConfig apiProvisioningConfig, @NotNull DeploymentConfig deploymentConfig) {
        super((Environment)target.getParent(), appName, file, filename, apiProvisioningConfig, deploymentConfig);
        this.target = target;
    }

    @Override
    protected DeploymentResult doDeploy() throws IOException, HttpException {
        HttpHelper.MultiPartRequest request;
        long start = System.currentTimeMillis();
        AnypointClient client = this.environment.getClient();
        HttpHelper httpHelper = client.getHttpHelper();
        try {
            logger.debug("Searching for pre-existing application named " + this.appName);
            HApplication application = this.target.findApplication(this.appName);
            logger.debug("Found application named {} : {}", (Object)this.appName, (Object)application.getId());
            request = httpHelper.createAnypointMultiPartPatchRequest("/hybrid/api/v1/applications/" + application.getId(), (Environment)this.target.getParent());
        }
        catch (NotFoundException e) {
            logger.debug("Couldn't find application named {}", (Object)this.appName);
            request = httpHelper.createAnypointMultiPartPostRequest("/hybrid/api/v1/applications", this.environment);
        }
        this.jsonHelper = this.target.getClient().getJsonHelper();
        HttpHelper.MultiPartRequest multiPartRequest = request.addText("artifactName", this.appName).addText("targetId", this.target.getId());
        HashMap rootCfg = new HashMap();
        HashMap<String, Object> appCfg = new HashMap<String, Object>();
        appCfg.put("applicationName", this.appName);
        appCfg.put("properties", this.deploymentConfig.getProperties());
        rootCfg.put("mule.agent.application.properties.service", appCfg);
        String cfgJson = this.jsonHelper.getJsonMapper().writeValueAsString(rootCfg);
        logger.debug("Added config to hybrid deploy {}", (Object)cfgJson);
        multiPartRequest.addText("configuration", cfgJson);
        logger.debug("Sending hybrid deploy request: {}", (Object)multiPartRequest);
        multiPartRequest = multiPartRequest.addBinary("file", new StreamSource(){

            @Override
            public String getFileName() {
                return HDeployer.this.filename;
            }

            @Override
            public InputStream createInputStream() throws IOException {
                return new FileInputStream(HDeployer.this.source.getLocalFile());
            }
        });
        elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Uploading application archive to on-prem server", new Object[0]);
        String json = this.executeRequest(start, multiPartRequest);
        elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Application starting", new Object[0]);
        HApplication application = this.jsonHelper.readJson(new HApplication(this.target), json, "/data");
        return new HDeploymentResult(application);
    }
}

