/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.legacy.deploy.rtf;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.UnexpectedException;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.application.ApplicationIdentifier;
import com.aeontronix.enhancedmule.tools.application.deploy.RTFDeploymentConfig;
import com.aeontronix.enhancedmule.tools.fabric.Fabric;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.legacy.deploy.Deployer;
import com.aeontronix.enhancedmule.tools.legacy.deploy.DeploymentConfig;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningConfig;
import com.aeontronix.enhancedmule.tools.runtime.DeploymentResult;
import com.aeontronix.enhancedmule.tools.runtime.Target;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RTFDeployer
extends Deployer {
    private final Fabric fabric;
    private ApplicationIdentifier appId;

    public RTFDeployer(Fabric fabric, Environment environment, String appName, ApplicationSource applicationSource, String filename, APIProvisioningConfig apiProvisioningConfig, DeploymentConfig deploymentConfig, ApplicationIdentifier appId) {
        super(environment, appName, applicationSource, filename, apiProvisioningConfig, deploymentConfig);
        this.fabric = fabric;
        this.appId = appId;
    }

    @NotNull
    private static Map<String, Object> subMap(Map<String, Object> req, String name) {
        HashMap<String, Object> target = new HashMap<String, Object>();
        req.put(name, target);
        return target;
    }

    @Override
    protected DeploymentResult doDeploy() throws IOException, HttpException {
        RTFDeploymentConfig rtf = this.deploymentConfig.getRtf();
        if (StringUtils.isBlank((String)rtf.getRuntimeVersion())) {
            try {
                Target target = this.environment.getOrganization().findTargetById(this.fabric.getId());
                Target.Runtime runtime = target.findRuntimeByType("mule");
                if (runtime == null) {
                    throw new IllegalArgumentException("Unable to find mule runtimes (no mule runtimes in fabric), please explicitly set runtime version");
                }
                List<Target.RuntimeVersion> versions = runtime.getVersions();
                if (versions == null || versions.isEmpty()) {
                    throw new IllegalArgumentException("Unable to find mule runtimes version (no versions found), please explicitly set runtime version");
                }
                Target.RuntimeVersion version = versions.get(0);
                rtf.setRuntimeVersion(version.getBaseVersion() + ":" + version.getTag());
            }
            catch (NotFoundException e) {
                throw new UnexpectedException("RTF Target not found: " + this.fabric.getId());
            }
        }
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("name", this.appName);
        req.put("labels", Collections.singletonList("beta"));
        Map<String, Object> target = RTFDeployer.subMap(req, "target");
        target.put("provider", "MC");
        target.put("targetId", this.fabric.getId());
        Map<String, Object> deploymentSettings = RTFDeployer.subMap(target, "deploymentSettings");
        Map<String, Object> resources = RTFDeployer.subMap(deploymentSettings, "resources");
        Map<String, Object> cpu = RTFDeployer.subMap(resources, "cpu");
        cpu.put("reserved", rtf.getCpuReserved());
        cpu.put("limit", rtf.getCpuLimit());
        Map<String, Object> memory = RTFDeployer.subMap(resources, "memory");
        memory.put("reserved", rtf.getMemoryReserved());
        memory.put("limit", rtf.getMemoryLimit());
        deploymentSettings.put("clustered", rtf.isClustered());
        deploymentSettings.put("enforceDeployingReplicasAcrossNodes", rtf.isEnforceDeployingReplicasAcrossNodes());
        Map<String, Object> http = RTFDeployer.subMap(deploymentSettings, "http");
        Map<String, Object> inbound = RTFDeployer.subMap(http, "inbound");
        inbound.put("publicUrl", rtf.getHttpInboundPublicUrl());
        Map<String, Object> jvm = RTFDeployer.subMap(deploymentSettings, "jvm");
        if (rtf.getJvmArgs() != null) {
            jvm.put("args", rtf.getJvmArgs());
        }
        deploymentSettings.put("runtimeVersion", rtf.getRuntimeVersion());
        deploymentSettings.put("lastMileSecurity", rtf.isLastMileSecurity());
        deploymentSettings.put("forwardSslSession", rtf.isForwardSslSession());
        deploymentSettings.put("updateStrategy", rtf.getUpdateStrategy() != null ? rtf.getUpdateStrategy().name().toLowerCase() : "rolling");
        target.put("replicas", rtf.getReplicas());
        Map<String, Object> application = RTFDeployer.subMap(req, "application");
        Map<String, Object> ref = RTFDeployer.subMap(application, "ref");
        ref.put("groupId", this.appId.getGroupId());
        ref.put("artifactId", this.appId.getArtifactId());
        ref.put("version", this.appId.getVersion());
        ref.put("packaging", "jar");
        application.put("desiredState", "STARTED");
        Map<String, Object> configuration = RTFDeployer.subMap(application, "configuration");
        Map<String, Object> properties = RTFDeployer.subMap(configuration, "mule.agent.application.properties.service");
        properties.put("applicationName", this.appName);
        properties.put("properties", this.deploymentConfig.getProperties());
        properties.put("secureproperties", Collections.emptyMap());
        String json = this.environment.getClient().getHttpHelper().httpPost(new URLBuilder("/hybrid/api/v2/organizations").path(((Organization)this.environment.getParent()).getId()).path("environments").path(this.environment.getId()).path("deployments").toString(), req);
        return null;
    }
}

