/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.provisioning;

import com.aeontronix.enhancedmule.tools.alert.AlertAction;
import com.aeontronix.enhancedmule.tools.alert.AlertSeverity;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.provisioning.ProvisioningScope;
import com.aeontronix.enhancedmule.tools.util.MarkdownHelper;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AlertDescriptor {
    private String id;
    @JsonProperty(required=true)
    private AlertSeverity severity;
    @JsonProperty(required=true)
    private String name;
    @JsonProperty(required=true)
    private String conditionType;
    @JsonProperty(required=true)
    private List<String> conditionResources;
    @JsonProperty(required=true)
    private String conditionResourceType;
    @JsonProperty
    private List<AlertAction> actions;
    private List<ProvisioningScope> scopes = new ArrayList<ProvisioningScope>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AlertSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(AlertSeverity severity) {
        this.severity = severity;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(String conditionType) {
        this.conditionType = conditionType;
    }

    public List<String> getConditionResources() {
        return this.conditionResources;
    }

    public void setConditionResources(List<String> conditionResources) {
        this.conditionResources = conditionResources;
    }

    public String getConditionResourceType() {
        return this.conditionResourceType;
    }

    public void setConditionResourceType(String conditionResourceType) {
        this.conditionResourceType = conditionResourceType;
    }

    public List<AlertAction> getActions() {
        return this.actions;
    }

    public void setActions(List<AlertAction> actions) {
        this.actions = actions;
    }

    @NotNull
    public List<ProvisioningScope> getScopes() {
        return this.scopes;
    }

    public void setScopes(@NotNull List<ProvisioningScope> scopes) {
        this.scopes = scopes;
    }

    public void toMarkdown(Writer w, int headingDepth) throws IOException {
        MarkdownHelper.writeHeader(w, 2 + headingDepth, this.name);
        MarkdownHelper.writeParagraph(w, "Severity: " + this.severity.name());
        MarkdownHelper.writeParagraph(w, "Condition Type: " + this.conditionType);
        MarkdownHelper.writeParagraph(w, "Condition Resource Type: " + this.conditionResourceType);
        MarkdownHelper.writeParagraph(w, "Condition Resources: " + String.join((CharSequence)", ", this.conditionResources));
        MarkdownHelper.writeParagraph(w, "Environment: " + this.scopes.stream().map(ProvisioningScope::toShortMarkdown).collect(Collectors.joining(", ")));
        if (this.actions != null && !this.actions.isEmpty()) {
            MarkdownHelper.writeParagraph(w, "Actions: ");
            for (AlertAction action : this.actions) {
                MarkdownHelper.writeParagraph(w, "Email to: " + String.join((CharSequence)", ", action.getEmails().toArray(new String[0])));
                MarkdownHelper.writeParagraph(w, "Email subject: " + action.getSubject());
                MarkdownHelper.writeParagraph(w, "Content:");
                MarkdownHelper.writeParagraph(w, "> " + action.getContent().replaceAll("\n", "\n> "));
            }
        }
    }

    public void provision(Organization org, ArrayList<Environment> envs) {
    }
}

