/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.provisioning;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.provisioning.ProvisioningException;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentDescriptor.class);
    private String name;
    private String description;
    private String group;
    private Environment.Type type;

    public Environment provision(Organization org) throws HttpException, ProvisioningException {
        Environment env;
        try {
            if (StringUtils.isBlank((String)this.name)) {
                throw new ProvisioningException("environment name missing");
            }
            env = org.findEnvironmentByName(this.name);
        }
        catch (NotFoundException e) {
            env = org.createEnvironment(this.name, this.type);
            logger.info("Created environment {}", (Object)this.name);
        }
        if (this.group != null) {
            env.setGroup(this.group);
        }
        return env;
    }

    @JsonProperty(required=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @JsonProperty(required=true)
    public Environment.Type getType() {
        return this.type;
    }

    public void setType(Environment.Type type) {
        this.type = type;
    }

    public String toString() {
        return "EnvironmentDescriptor{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }
}

