/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.provisioning;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.provisioning.AlertDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.EnvironmentDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.ProvisioningException;
import com.aeontronix.enhancedmule.tools.provisioning.RoleDescriptor;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.MarkdownHelper;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationDescriptor.class);
    private String name;
    private String id;
    private String parentId;
    private String ownerId;
    private boolean createSubOrgs = true;
    private boolean createEnvironments = true;
    private boolean globalDeployment = true;
    private int vCoresProduction;
    private int vCoresSandbox;
    private int vCoresDesign;
    private int staticIps;
    private int vpcs;
    private int loadBalancer;
    private List<EnvironmentDescriptor> environments;
    private List<RoleDescriptor> roles;
    private List<AlertDescriptor> runtimeAlerts;

    public void toMarkdown(Writer w, int headingDepth) throws IOException {
        if (this.environments != null && !this.environments.isEmpty()) {
            MarkdownHelper.writeHeader(w, headingDepth + 1, "Environments");
            MarkdownHelper.writeParagraph(w, "Manual setup instruction: [https://docs.mulesoft.com/access-management/environments](https://docs.mulesoft.com/access-management/environments)");
            for (EnvironmentDescriptor environment : this.environments) {
                MarkdownHelper.writeHeader(w, headingDepth + 2, environment.getName());
                MarkdownHelper.writeParagraph(w, "Type: " + (Object)((Object)environment.getType()));
                MarkdownHelper.writeParagraph(w, "Description: " + environment.getDescription());
            }
        }
        if (this.roles != null && !this.roles.isEmpty()) {
            MarkdownHelper.writeHeader(w, headingDepth + 1, "Roles");
            MarkdownHelper.writeParagraph(w, "Manual setup instruction: [https://docs.mulesoft.com/access-management/roles](https://docs.mulesoft.com/access-management/roles)");
            for (RoleDescriptor role : this.roles) {
                role.toMarkdown(w, headingDepth);
            }
        }
        if (this.runtimeAlerts != null && !this.runtimeAlerts.isEmpty()) {
            MarkdownHelper.writeHeader(w, 1 + headingDepth, "Alerts");
            MarkdownHelper.writeParagraph(w, "Manual setup instruction: [https://docs.mulesoft.com/runtime-manager/alerts-on-runtime-manager](https://docs.mulesoft.com/runtime-manager/alerts-on-runtime-manager)");
            for (AlertDescriptor alert : this.runtimeAlerts) {
                alert.toMarkdown(w, headingDepth);
            }
        }
        w.write(10);
    }

    public Organization provision(AnypointClient client) throws NotFoundException, HttpException, ProvisioningException {
        Organization org;
        if (this.ownerId == null) {
            this.ownerId = client.getUserId();
            logger.debug("No owner id specified, using {}", (Object)this.ownerId);
        }
        if (this.id != null) {
            org = client.findOrganizationById(this.id);
        } else if (this.name != null) {
            try {
                org = client.findOrganizationByNameOrId(this.name);
            }
            catch (NotFoundException e) {
                logger.info("Organization not found, creating");
                if (this.parentId != null) {
                    Organization parentOrg = client.findOrganizationById(this.parentId);
                    org = parentOrg.createSubOrganization(this.name, this.ownerId, this.createSubOrgs, this.createEnvironments, this.globalDeployment, this.vCoresProduction, this.vCoresSandbox, this.vCoresDesign, this.staticIps, this.vpcs, this.loadBalancer);
                } else {
                    org = client.createOrganization(this.name, this.ownerId, this.createSubOrgs, this.createEnvironments, this.globalDeployment, this.vCoresProduction, this.vCoresSandbox, this.vCoresDesign, this.staticIps, this.vpcs, this.loadBalancer);
                }
                logger.info("Organization not found, created with id " + org.getId());
            }
        } else {
            throw new IllegalArgumentException("Organization descriptor must have an id or a name");
        }
        ArrayList<Environment> envs = new ArrayList<Environment>();
        if (this.environments != null) {
            for (EnvironmentDescriptor environment : this.environments) {
                envs.add(environment.provision(org));
            }
        }
        if (this.roles != null) {
            for (RoleDescriptor role : this.roles) {
                role.provision(org, envs);
            }
        }
        if (this.runtimeAlerts != null) {
            for (AlertDescriptor runtimeAlert : this.runtimeAlerts) {
                runtimeAlert.provision(org, envs);
            }
        }
        return org;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public boolean isCreateSubOrgs() {
        return this.createSubOrgs;
    }

    public void setCreateSubOrgs(boolean createSubOrgs) {
        this.createSubOrgs = createSubOrgs;
    }

    public boolean isCreateEnvironments() {
        return this.createEnvironments;
    }

    public void setCreateEnvironments(boolean createEnvironments) {
        this.createEnvironments = createEnvironments;
    }

    public boolean isGlobalDeployment() {
        return this.globalDeployment;
    }

    public void setGlobalDeployment(boolean globalDeployment) {
        this.globalDeployment = globalDeployment;
    }

    public int getvCoresProduction() {
        return this.vCoresProduction;
    }

    public void setvCoresProduction(int vCoresProduction) {
        this.vCoresProduction = vCoresProduction;
    }

    public int getvCoresSandbox() {
        return this.vCoresSandbox;
    }

    public void setvCoresSandbox(int vCoresSandbox) {
        this.vCoresSandbox = vCoresSandbox;
    }

    public int getvCoresDesign() {
        return this.vCoresDesign;
    }

    public void setvCoresDesign(int vCoresDesign) {
        this.vCoresDesign = vCoresDesign;
    }

    public int getStaticIps() {
        return this.staticIps;
    }

    public void setStaticIps(int staticIps) {
        this.staticIps = staticIps;
    }

    public int getVpcs() {
        return this.vpcs;
    }

    public void setVpcs(int vpcs) {
        this.vpcs = vpcs;
    }

    public int getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(int loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public List<AlertDescriptor> getRuntimeAlerts() {
        return this.runtimeAlerts;
    }

    public void setRuntimeAlerts(List<AlertDescriptor> runtimeAlerts) {
        this.runtimeAlerts = runtimeAlerts;
    }

    public List<EnvironmentDescriptor> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<EnvironmentDescriptor> environments) {
        this.environments = environments;
    }

    public List<RoleDescriptor> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RoleDescriptor> roles) {
        this.roles = roles;
    }

    public static Organization provision(AnypointClient client, File orgDescriptorFile, String orgName) throws NotFoundException, HttpException, IOException, ProvisioningException {
        OrganizationDescriptor org = (OrganizationDescriptor)client.getJsonHelper().getJsonMapper().readValue(orgDescriptorFile, OrganizationDescriptor.class);
        if (StringUtils.isNotBlank((String)orgName)) {
            org.setName(orgName);
        }
        return org.provision(client);
    }

    public static void toMarkdown(AnypointClient client, Writer w, File file, int headingDepth) throws IOException {
        OrganizationDescriptor org = (OrganizationDescriptor)client.getJsonHelper().getJsonMapper().readValue(file, OrganizationDescriptor.class);
        org.toMarkdown(w, headingDepth);
    }
}

