/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.provisioning.api;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.TempFile;
import com.aeontronix.commons.validation.ValidationUtils;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetCategory;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetCreationException;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAsset;
import com.aeontronix.enhancedmule.tools.api.API;
import com.aeontronix.enhancedmule.tools.api.APISpec;
import com.aeontronix.enhancedmule.tools.api.SLATier;
import com.aeontronix.enhancedmule.tools.api.SLATierLimits;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.provisioning.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.ProvisioningException;
import com.aeontronix.enhancedmule.tools.provisioning.api.APICustomFieldDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningConfig;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningResult;
import com.aeontronix.enhancedmule.tools.provisioning.api.IconDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.PolicyDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.SLATierDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.portal.PortalDescriptor;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(APIDescriptor.class);
    private static final EMTLogger plogger = new EMTLogger(logger);
    private String assetId;
    private String assetVersion;
    private String name;
    private String description;
    private String version;
    @Deprecated
    private String apiVersion;
    private String implementationUrl;
    private String consumerUrl;
    private Map<String, Object> implementationUrlJson;
    private List<String> tags;
    private List<String> exchangeTags;
    private boolean addAutoDiscovery = false;
    private String autoDiscoveryFlow = "api-main";
    private List<PolicyDescriptor> policies;
    private List<String> accessedBy;
    private String label;
    private List<SLATierDescriptor> slaTiers;
    private API.Type type = API.Type.REST;
    private Boolean assetCreate;
    private String assetMainFile;
    private PortalDescriptor portal;
    private Map<String, List<String>> categories;
    private List<APICustomFieldDescriptor> fields;
    private IconDescriptor icon;
    private String apiIdProperty;
    private boolean injectApiId = true;

    public APIDescriptor() {
    }

    public APIDescriptor(String assetId, String version) {
        this.assetId = assetId;
        this.assetVersion = version;
    }

    public void provision(ApplicationDescriptor cfg, Environment environment, APIProvisioningConfig config, ApplicationSource applicationSource, APIProvisioningResult result) throws ProvisioningException {
        try {
            API api;
            if (this.version == null && this.apiVersion != null) {
                this.version = this.apiVersion;
            }
            ValidationUtils.notEmpty(IllegalStateException.class, (String)"API Descriptor missing value: assetId", (String[])new String[]{this.assetId});
            ValidationUtils.notEmpty(IllegalStateException.class, (String)"API Descriptor missing value: assetVersion", (String[])new String[]{this.assetVersion});
            Organization organization = (Organization)environment.getParent();
            logger.info("Provisioning " + this.getAssetId() + " within org " + organization.getName() + " env " + environment.getName());
            Boolean m3 = cfg.getMule3();
            if (m3 == null) {
                m3 = false;
            }
            boolean updateEndpoint = true;
            try {
                api = environment.findAPIByExchangeAssetIdOrNameAndVersion(this.getAssetId(), this.getAssetVersion(), this.label);
                logger.debug("API " + this.getAssetId() + " " + this.getAssetVersion() + " exists: " + api);
            }
            catch (NotFoundException e) {
                APISpec apiSpec;
                logger.debug("API " + this.getAssetId() + " " + this.getAssetVersion() + " not found, creating");
                try {
                    apiSpec = organization.findAPISpecsByIdOrNameAndVersion(this.getAssetId(), this.getAssetVersion());
                }
                catch (NotFoundException ex) {
                    if (this.assetCreate.booleanValue()) {
                        if (this.type == API.Type.HTTP) {
                            environment.getOrganization().createExchangeHTTPAPIAsset(null, this.assetId, this.assetId, this.assetVersion, this.version);
                            plogger.info(EMTLogger.Product.EXCHANGE, "Created HTTP asset : {} : {} : {}", this.assetId, this.assetVersion, this.version);
                        } else {
                            if (applicationSource == null) {
                                throw new AssetCreationException("Cannot create asset due to missing application source (standalone provisioning doesn't support REST asset creation)");
                            }
                            if (StringUtils.isBlank((String)this.assetMainFile)) {
                                throw new AssetCreationException("assetMainFile is required for API asset creation");
                            }
                            String assetClassifier = this.assetMainFile.toLowerCase().endsWith(".raml") ? "raml" : "oas";
                            try (TempFile apiSpecFile = new TempFile(this.assetId + "-" + this.assetVersion);){
                                applicationSource.copyAPISpecs(this.assetMainFile, apiSpecFile);
                                environment.getOrganization().publishExchangeAPIAsset(this.name, this.assetId, this.assetVersion, this.version, assetClassifier, this.assetMainFile, (File)apiSpecFile);
                                plogger.info(EMTLogger.Product.EXCHANGE, "Created API asset : {} : {} : {}", this.assetId, this.assetVersion, this.version);
                            }
                        }
                    } else {
                        throw ex;
                    }
                    apiSpec = organization.findAPISpecsByIdOrNameAndVersion(this.getAssetId(), this.getAssetVersion());
                }
                String productAPIVersion = apiSpec.getProductAPIVersion();
                try {
                    logger.debug("findAPIByExchangeAssetIdOrNameAndProductAPIVersion: {} , {} , {}", new Object[]{this.getAssetId(), productAPIVersion, this.label});
                    api = environment.findAPIByExchangeAssetIdOrNameAndProductAPIVersion(this.getAssetId(), productAPIVersion, this.label);
                    String currentAssetVersion = api.getAssetVersion();
                    if (!currentAssetVersion.equalsIgnoreCase(this.assetVersion)) {
                        api = api.updateVersion(this.assetVersion);
                        plogger.info(EMTLogger.Product.API_MANAGER, "Updated asset {} version to {}", api.getAssetId(), this.assetVersion);
                    }
                }
                catch (NotFoundException ex) {
                    logger.debug("Creating API");
                    api = this.implementationUrlJson != null ? environment.createAPI(apiSpec, this.label, this.implementationUrlJson, this.consumerUrl) : environment.createAPI(apiSpec, m3 == false, this.implementationUrl, this.consumerUrl, this.label, this.type);
                    plogger.info(EMTLogger.Product.API_MANAGER, "Created api {}", api.getAssetId(), this.assetVersion);
                    updateEndpoint = false;
                }
            }
            if (this.policies != null) {
                plogger.info(EMTLogger.Product.API_MANAGER, "Setting policies for {}", api.getAssetId());
                api.deletePolicies();
                for (PolicyDescriptor policyDescriptor : this.policies) {
                    api.createPolicy(policyDescriptor);
                }
            }
            if (this.slaTiers != null) {
                plogger.info(EMTLogger.Product.API_MANAGER, "Setting SLA Tiers for {}", api.getAssetId());
                for (SLATierDescriptor slaTierDescriptor : this.slaTiers) {
                    try {
                        SLATier slaTier = api.findSLATier(slaTierDescriptor.getName());
                        slaTier.setAutoApprove(slaTierDescriptor.isAutoApprove());
                        slaTier.setDescription(slaTierDescriptor.getDescription());
                        slaTier.setLimits(slaTierDescriptor.getLimits());
                        slaTier = slaTier.update();
                    }
                    catch (NotFoundException e) {
                        api.createSLATier(slaTierDescriptor.getName(), slaTierDescriptor.getDescription(), slaTierDescriptor.isAutoApprove(), slaTierDescriptor.getLimits());
                    }
                }
            }
            if (this.consumerUrl != null) {
                api.updateConsumerUrl(this.consumerUrl);
                plogger.info(EMTLogger.Product.API_MANAGER, "Updated consumer url to {}", this.consumerUrl);
            }
            if (this.implementationUrlJson != null) {
                api.updateImplementationUrl(this.implementationUrlJson);
                plogger.info(EMTLogger.Product.API_MANAGER, "Updated implementation url to {}", this.implementationUrlJson.toString());
            } else if (this.implementationUrl != null) {
                api.updateImplementationUrl(this.implementationUrl, m3 == false, this.type);
                plogger.info(EMTLogger.Product.API_MANAGER, "Updated implementation url to {}", this.implementationUrl);
            }
            api = api.refresh();
            result.setApi(api);
            if (logger.isDebugEnabled()) {
                logger.debug("api: {}", (Object)api.toString());
            }
            ExchangeAsset exchangeAsset = environment.getOrganization().findExchangeAsset(api.getGroupId(), api.getAssetId());
            if (this.name != null && !this.name.equals(exchangeAsset.getName())) {
                exchangeAsset.updateName(this.name);
                plogger.info(EMTLogger.Product.EXCHANGE, "Updated exchange asset '{}' name", exchangeAsset.getAssetId());
            }
            if (this.description != null && !this.description.equals(exchangeAsset.getDescription())) {
                exchangeAsset.updateDescription(this.description);
                plogger.info(EMTLogger.Product.EXCHANGE, "Updated exchange asset '{}' description", exchangeAsset.getAssetId());
            }
            exchangeAsset = this.updateExchangeTags(exchangeAsset);
            if (this.icon != null) {
                exchangeAsset.updateIcon(StringUtils.base64Decode((String)this.icon.getContent()), this.icon.getMimeType());
                plogger.info(EMTLogger.Product.EXCHANGE, "Updated exchange asset '{}' icon", exchangeAsset.getAssetId());
            }
            ExchangeAsset.CustomFieldUpdateResults results = exchangeAsset.updateCustomFields(this.fields);
            for (String field : results.getModified()) {
                plogger.info(EMTLogger.Product.EXCHANGE, "Updated exchange asset '{}' custom field '{}'", exchangeAsset.getAssetId(), field);
            }
            for (String field : results.getNotDefined()) {
                logger.warn("Custom field not defined, assignment failed: " + field);
            }
            this.updateExchangeCategories(exchangeAsset);
            if (this.portal != null) {
                this.portal.provision(exchangeAsset);
            }
        }
        catch (NotFoundException | AssetCreationException | IOException e) {
            throw new ProvisioningException(e);
        }
    }

    private void updateExchangeCategories(ExchangeAsset exchangeAsset) throws HttpException {
        if (this.categories != null) {
            Map<String, List> assetCategories = exchangeAsset.getCategories().stream().collect(Collectors.toMap(AssetCategory::getKey, AssetCategory::getValue));
            for (String string : assetCategories.keySet()) {
                if (this.categories.containsKey(string)) continue;
                exchangeAsset.deleteCategory(string);
                plogger.info(EMTLogger.Product.EXCHANGE, "Updated exchange asset '{}' category '{}'", exchangeAsset.getAssetId(), string);
            }
            for (Map.Entry entry : this.categories.entrySet()) {
                String catKey;
                List assetCatValues;
                List catValues = entry.getValue() != null ? (List)entry.getValue() : Collections.emptyList();
                if (catValues.equals(assetCatValues = assetCategories.getOrDefault(catKey = (String)entry.getKey(), Collections.emptyList()))) continue;
                exchangeAsset.updateCategory(catKey, catValues);
                plogger.info(EMTLogger.Product.EXCHANGE, "Updated exchange asset '{}' category '{}' to '{}'", exchangeAsset.getAssetId(), catKey, catValues);
            }
        }
    }

    private ExchangeAsset updateExchangeTags(ExchangeAsset exchangeAsset) throws HttpException {
        List<String> expectedTags;
        List<String> current;
        if (this.exchangeTags != null && !(current = exchangeAsset.getLabels()).equals(expectedTags = this.exchangeTags)) {
            exchangeAsset = exchangeAsset.updateLabels(expectedTags);
            plogger.info(EMTLogger.Product.EXCHANGE, "Updated tags of {} : {}", exchangeAsset.getAssetId(), expectedTags);
        }
        return exchangeAsset;
    }

    @JsonProperty(defaultValue="true")
    public boolean isInjectApiId() {
        return this.injectApiId;
    }

    public void setInjectApiId(boolean injectApiId) {
        this.injectApiId = injectApiId;
    }

    @JsonProperty
    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    @JsonProperty
    public String getAssetVersion() {
        return this.assetVersion;
    }

    public void setAssetVersion(String assetVersion) {
        this.assetVersion = assetVersion;
    }

    public void addPolicy(PolicyDescriptor policy) {
        this.getPolicies().add(policy);
    }

    @JsonProperty
    public synchronized List<PolicyDescriptor> getPolicies() {
        if (this.policies == null) {
            this.policies = new ArrayList<PolicyDescriptor>();
        }
        return this.policies;
    }

    public void setPolicies(List<PolicyDescriptor> policies) {
        this.policies = policies;
    }

    @JsonProperty
    public List<String> getAccessedBy() {
        return this.accessedBy;
    }

    public void setAccessedBy(List<String> accessedBy) {
        this.accessedBy = accessedBy;
    }

    public synchronized List<SLATierDescriptor> getSlaTiers() {
        return this.slaTiers;
    }

    public synchronized void setSlaTiers(List<SLATierDescriptor> slaTiers) {
        this.slaTiers = slaTiers;
    }

    public synchronized APIDescriptor addSlaTier(String name, String description, boolean autoApprove, SLATierLimits ... limits) {
        return this.addSlaTier(new SLATierDescriptor(name, description, autoApprove, limits));
    }

    public synchronized APIDescriptor addSlaTier(String name, boolean autoApprove, SLATierLimits ... limits) {
        return this.addSlaTier(name, null, autoApprove, limits);
    }

    public synchronized APIDescriptor addSlaTier(SLATierDescriptor slaTierDescriptor) {
        if (this.slaTiers == null) {
            this.slaTiers = new ArrayList<SLATierDescriptor>();
        }
        this.slaTiers.add(slaTierDescriptor);
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public API.Type getType() {
        return this.type;
    }

    public void setType(API.Type type) {
        this.type = type;
    }

    public Boolean isAssetCreate() {
        return this.assetCreate;
    }

    public void setAssetCreate(Boolean assetCreate) {
        this.assetCreate = assetCreate;
    }

    public boolean isAddAutoDiscovery() {
        return this.addAutoDiscovery;
    }

    public void setAddAutoDiscovery(boolean addAutoDiscovery) {
        this.addAutoDiscovery = addAutoDiscovery;
    }

    public String getAutoDiscoveryFlow() {
        return this.autoDiscoveryFlow;
    }

    public void setAutoDiscoveryFlow(String autoDiscoveryFlow) {
        this.autoDiscoveryFlow = autoDiscoveryFlow;
    }

    public String getAssetMainFile() {
        return this.assetMainFile;
    }

    public void setAssetMainFile(String assetMainFile) {
        this.assetMainFile = assetMainFile;
    }

    @Deprecated
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Deprecated
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<String> getExchangeTags() {
        return this.exchangeTags;
    }

    public void setExchangeTags(List<String> exchangeTags) {
        this.exchangeTags = exchangeTags;
    }

    public PortalDescriptor getPortal() {
        return this.portal;
    }

    public void setPortal(PortalDescriptor portal) {
        this.portal = portal;
    }

    public Map<String, List<String>> getCategories() {
        return this.categories;
    }

    public void setCategories(Map<String, List<String>> categories) {
        this.categories = categories;
    }

    public List<APICustomFieldDescriptor> getFields() {
        return this.fields;
    }

    public void setFields(List<APICustomFieldDescriptor> fields) {
        this.fields = fields;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IconDescriptor getIcon() {
        return this.icon;
    }

    public void setIcon(IconDescriptor icon) {
        this.icon = icon;
    }

    @JsonProperty
    public String getImplementationUrl() {
        return this.implementationUrl;
    }

    public void setImplementationUrl(String implementationUrl) {
        this.implementationUrl = implementationUrl;
    }

    @JsonProperty
    public String getConsumerUrl() {
        return this.consumerUrl;
    }

    public void setConsumerUrl(String consumerUrl) {
        this.consumerUrl = consumerUrl;
    }

    @JsonProperty
    public Map<String, Object> getImplementationUrlJson() {
        return this.implementationUrlJson;
    }

    public void setImplementationUrlJson(Map<String, Object> implementationUrlJson) {
        this.implementationUrlJson = implementationUrlJson;
    }

    public String getApiIdProperty() {
        return this.apiIdProperty;
    }

    public void setApiIdProperty(String apiIdProperty) {
        this.apiIdProperty = apiIdProperty;
    }
}

