/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.provisioning.api;

import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class APIProvisioningConfig {
    @JsonProperty(defaultValue="anypoint.json")
    private String descriptorLocation = "anypoint.json";
    @JsonProperty
    private Map<String, String> variables = new HashMap<String, String>();
    @JsonProperty
    private List<String> accessedBy = new ArrayList<String>();
    @JsonProperty
    private String apiLabel;
    @JsonProperty(defaultValue="true")
    private boolean autoApproveAPIAccessRequest = true;

    public APIProvisioningConfig() {
    }

    public APIProvisioningConfig(Map<String, String> variables, List<String> accessedBy) {
        this.variables.putAll(variables);
        if (accessedBy != null) {
            this.accessedBy.addAll(accessedBy);
        }
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public void setVariable(String key, String value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, String>();
        }
        this.variables.put(key, value);
    }

    public List<String> getAccessedBy() {
        return this.accessedBy;
    }

    public void addAccessedBy(String clientAppName) {
        this.accessedBy.add(clientAppName);
    }

    public void setAccessedBy(List<String> accessedBy) {
        this.accessedBy = accessedBy;
    }

    public String getDescriptorLocation() {
        return this.descriptorLocation;
    }

    public void setDescriptorLocation(String descriptorLocation) {
        this.descriptorLocation = descriptorLocation;
    }

    public void addVariable(String key, String value) {
        this.variables.put(key, value);
    }

    public String getApiLabel() {
        return this.apiLabel;
    }

    public void setApiLabel(String apiLabel) {
        this.apiLabel = apiLabel;
    }

    public boolean isAutoApproveAPIAccessRequest() {
        return this.autoApproveAPIAccessRequest;
    }

    public void setAutoApproveAPIAccessRequest(boolean autoApproveAPIAccessRequest) {
        this.autoApproveAPIAccessRequest = autoApproveAPIAccessRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APIProvisioningConfig)) {
            return false;
        }
        APIProvisioningConfig that = (APIProvisioningConfig)o;
        return this.autoApproveAPIAccessRequest == that.autoApproveAPIAccessRequest && Objects.equals(this.descriptorLocation, that.descriptorLocation) && Objects.equals(this.variables, that.variables) && Objects.equals(this.accessedBy, that.accessedBy) && Objects.equals(this.apiLabel, that.apiLabel);
    }

    public int hashCode() {
        return Objects.hash(this.descriptorLocation, this.variables, this.accessedBy, this.apiLabel, this.autoApproveAPIAccessRequest);
    }

    public String toString() {
        return new StringJoiner(", ", APIProvisioningConfig.class.getSimpleName() + "[", "]").add("descriptorLocation='" + this.descriptorLocation + "'").add("variables=" + this.variables).add("accessedBy=" + this.accessedBy).add("apiLabel='" + this.apiLabel + "'").add("autoApproveAPIAccessRequest=" + this.autoApproveAPIAccessRequest).toString();
    }

    public void setEnvironment(Environment environment) {
        this.setVariable("environment.id", environment.getId());
        this.setVariable("environment.name", environment.getName());
        this.setVariable("environment.lname", environment.getLName());
        this.setOrganization(environment.getOrganization());
    }

    public void setOrganization(Organization organization) {
        this.setVariable("organization.name", organization.getName());
        this.setVariable("organization.lname", organization.getName().replace(" ", "_").toLowerCase());
    }
}

