/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.provisioning.api;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetInstance;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAsset;
import com.aeontronix.enhancedmule.tools.api.API;
import com.aeontronix.enhancedmule.tools.api.APIContract;
import com.aeontronix.enhancedmule.tools.api.ClientApplication;
import com.aeontronix.enhancedmule.tools.api.SLATier;
import com.aeontronix.enhancedmule.tools.provisioning.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.ProvisioningException;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIAccessDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningConfig;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningResult;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.UnauthorizedHttpException;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientApplicationDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(ClientApplicationDescriptor.class);
    private static final EMTLogger plogger = new EMTLogger(logger);
    private String url;
    private String description;
    private String name;
    private boolean injectClientIdSec = true;
    private String clientIdProperty;
    private String clientSecretProperty;
    private List<APIAccessDescriptor> access;

    public ClientApplicationDescriptor() {
    }

    public ClientApplicationDescriptor(String url, String description, String name) {
        this.url = url;
        this.description = description;
        this.name = name;
    }

    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(defaultValue="true")
    public boolean isInjectClientIdSec() {
        return this.injectClientIdSec;
    }

    public void setInjectClientIdSec(boolean injectClientIdSec) {
        this.injectClientIdSec = injectClientIdSec;
    }

    @JsonProperty
    public String getClientIdProperty() {
        return this.clientIdProperty;
    }

    public void setClientIdProperty(String clientIdProperty) {
        this.clientIdProperty = clientIdProperty;
    }

    @JsonProperty
    public String getClientSecretProperty() {
        return this.clientSecretProperty;
    }

    public void setClientSecretProperty(String clientSecretProperty) {
        this.clientSecretProperty = clientSecretProperty;
    }

    @JsonProperty(value="access")
    public synchronized List<APIAccessDescriptor> getAccess() {
        return this.access != null ? this.access : Collections.emptyList();
    }

    public synchronized void setAccess(List<APIAccessDescriptor> access) {
        this.access = access;
    }

    public synchronized ClientApplicationDescriptor addAccess(APIAccessDescriptor accessDescriptor) {
        if (this.access == null) {
            this.access = new ArrayList<APIAccessDescriptor>();
        }
        this.access.add(accessDescriptor);
        return this;
    }

    public synchronized ClientApplicationDescriptor addAccess(API api) {
        this.addAccess(new APIAccessDescriptor(api, null));
        return this;
    }

    public synchronized ClientApplicationDescriptor addAccess(API api, String slaTier) {
        this.addAccess(new APIAccessDescriptor(api, slaTier));
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void provision(ApplicationDescriptor applicationDescriptor, Environment environment, APIProvisioningConfig config, APIProvisioningResult result) throws ProvisioningException {
        try {
            String appId = applicationDescriptor.getId();
            if (this.name == null) {
                this.name = appId + "-" + config.getVariables().get("environment.lname");
            }
            ClientApplication clientApplication = null;
            try {
                clientApplication = environment.getOrganization().findClientApplicationByName(this.name);
                logger.debug("Client application found: " + this.name);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (clientApplication == null) {
                logger.debug("Client application not found, creating: " + this.name);
                String instanceId = null;
                if (this.access != null && !this.access.isEmpty()) {
                    instanceId = this.findAPIInstance(environment, this.access.get(0)).getId();
                }
                clientApplication = environment.getOrganization().createClientApplication(this.name, this.url, this.description, instanceId);
                plogger.info(EMTLogger.Product.API_MANAGER, "Created client application: {}", this.name);
            }
            result.setClientApplication(clientApplication);
            if (this.access == null) return;
            for (APIAccessDescriptor accessDescriptor : this.access) {
                AssetInstance instance = this.findAPIInstance(environment, accessDescriptor);
                logger.debug("Found instance {}", (Object)instance);
                Environment apiEnv = new Environment(new Organization(environment.getClient(), instance.getOrganizationId()), instance.getEnvironmentId());
                API accessedAPI = new API(apiEnv);
                accessedAPI.setId(instance.getId());
                logger.debug("Found apiEnv {} with id {}", (Object)apiEnv, (Object)apiEnv.getId());
                APIContract contract = null;
                try {
                    contract = accessedAPI.findContract(clientApplication);
                }
                catch (NotFoundException notFoundException) {
                }
                catch (UnauthorizedHttpException e) {
                    logger.warn("Unable to List contracts of api " + accessedAPI.getAssetId() + " due to lack of permissions: " + e.getMessage());
                }
                if (contract == null) {
                    SLATier slaTier = null;
                    if (accessDescriptor.getSlaTier() != null) {
                        slaTier = instance.findSLATier(accessDescriptor.getSlaTier());
                    } else {
                        List<SLATier> slaTiers = instance.findSLATiers();
                        if (slaTiers.size() == 1) {
                            slaTier = instance.findSLATier(slaTiers.iterator().next().getName());
                        }
                    }
                    contract = clientApplication.requestAPIAccess(accessedAPI, instance, slaTier);
                    plogger.info(EMTLogger.Product.API_MANAGER, "Requested API access from {} to {} ", clientApplication.getName(), accessedAPI.getAssetId());
                }
                if (contract.isApproved() || !config.isAutoApproveAPIAccessRequest()) continue;
                try {
                    if (contract.isRevoked()) {
                        contract.restoreAccess();
                        plogger.info(EMTLogger.Product.API_MANAGER, "Restored API access from {} to {} ", clientApplication.getName(), accessedAPI.getAssetId());
                        continue;
                    }
                    contract.approveAccess();
                    plogger.info(EMTLogger.Product.API_MANAGER, "Approved API access from {} to {} ", clientApplication.getName(), accessedAPI.getAssetId());
                }
                catch (HttpException e) {
                    if (e.getStatusCode() != 403) throw e;
                    logger.warn("Unable to approve access to " + accessDescriptor.getAssetId() + " due to lack of permissions: " + e.getMessage());
                    continue;
                    return;
                }
            }
        }
        catch (NotFoundException | HttpException e) {
            throw new ProvisioningException(e);
        }
    }

    private AssetInstance findAPIInstance(Environment environment, APIAccessDescriptor accessDescriptor) throws HttpException, NotFoundException {
        String accessEnvId;
        Organization accessOrg;
        logger.debug("Processing access descriptor : {}", (Object)accessDescriptor);
        if (accessDescriptor.getOrgId() == null) {
            logger.debug("Access descriptor has no org id, getting the default org");
            accessOrg = environment.getOrganization();
            accessDescriptor.setOrgId(accessOrg.getId());
        } else {
            accessOrg = environment.getOrganization().getClient().findOrganizationById(accessDescriptor.getOrgId());
        }
        if (StringUtils.isBlank((String)accessDescriptor.getAssetId())) {
            throw new IllegalArgumentException("access descriptor missing assetId");
        }
        logger.debug("Access org = {}", (Object)accessOrg.getId());
        if (accessDescriptor.getGroupId() == null) {
            logger.debug("No group id found, using the org id instead");
            accessDescriptor.setGroupId(accessOrg.getId());
        }
        logger.debug("Access group id = {}", (Object)accessDescriptor.getGroupId());
        if (accessDescriptor.getEnvId() != null) {
            logger.debug("Env id set: {}", (Object)accessDescriptor.getEnvId());
            accessEnvId = accessDescriptor.getEnvId();
        } else if (StringUtils.isNotBlank((String)accessDescriptor.getEnv())) {
            accessEnvId = accessOrg.findEnvironmentByName(accessDescriptor.getEnv()).getId();
            logger.debug("access environment specified");
        } else {
            logger.debug("No access environment specified, using the API's environment");
            accessEnvId = environment.getId();
        }
        logger.debug("Access environment id = {}", (Object)accessEnvId);
        ExchangeAsset exchangeAsset = accessOrg.findExchangeAsset(accessDescriptor.getGroupId(), accessDescriptor.getAssetId());
        logger.debug("Found exchangeAsset {}", (Object)exchangeAsset);
        logger.debug("exchangeAsset instances: {}", exchangeAsset.getInstances());
        return exchangeAsset.findInstances(accessDescriptor.getLabel(), accessEnvId);
    }
}

