/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.util.restclient;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.UnexpectedException;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.util.restclient.RESTAuthenticationProvider;
import com.aeontronix.enhancedmule.tools.util.restclient.RESTClientJsonParser;
import com.aeontronix.enhancedmule.tools.util.restclient.RESTClientJsonParserJacksonImpl;
import com.aeontronix.enhancedmule.tools.util.restclient.RESTException;
import com.aeontronix.enhancedmule.tools.util.restclient.ResponseStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.protocol.HttpContext;

public class RESTClient
implements Closeable,
AutoCloseable {
    private final List<RESTAuthenticationProvider> authenticationProviders = new ArrayList<RESTAuthenticationProvider>();
    private CloseableHttpClient httpClient;
    private String baseUrl;
    private RESTClientJsonParser jsonParser;

    public RESTClient() {
        this(new RESTClientJsonParserJacksonImpl(), null, null, null);
    }

    public RESTClient(RESTClientJsonParser jsonParser, HttpHost proxyHost, String proxyUsername, String proxyPassword) {
        this.jsonParser = jsonParser;
        this.setProxy(proxyHost, proxyUsername, proxyPassword);
    }

    public void addAuthProvider(RESTAuthenticationProvider provider) {
        this.authenticationProviders.add(provider);
    }

    public void setProxy(HttpHost proxyHost, String proxyUsername, String proxyPassword) {
        HttpClientBuilder builder = HttpClients.custom().disableCookieManagement();
        if (proxyHost != null) {
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost);
            builder = builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            if (StringUtils.isNotEmpty((String)proxyUsername) && StringUtils.isNotEmpty((String)proxyPassword)) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
                builder = builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
        builder.addInterceptorFirst((HttpRequestInterceptor)new AuthenticationFilter());
        this.httpClient = builder.build();
    }

    private String toUrl(String path) {
        if (path.startsWith("/")) {
            return new URLBuilder(this.baseUrl).path(path).toString();
        }
        return path;
    }

    public GetBuilder get(String path) throws RESTException {
        return new GetBuilder((HttpRequestBase)new HttpGet(this.toUrl(path)));
    }

    public PostBuilder postJson(String path, Object entity) {
        try {
            HttpPost method = new HttpPost(this.toUrl(path));
            method.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
            String json = this.jsonParser.toJson(entity);
            method.setEntity((HttpEntity)new StringEntity(json));
            return new PostBuilder((HttpRequestBase)method);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public class AuthenticationFilter
    implements HttpRequestInterceptor {
        public void process(HttpRequest req, HttpContext httpContext) throws HttpException, IOException {
            for (RESTAuthenticationProvider authenticationProvider : RESTClient.this.authenticationProviders) {
                if (!authenticationProvider.handles(req)) continue;
                authenticationProvider.process(req, httpContext);
            }
        }
    }

    public class GetBuilder
    extends AbstractMethodBuilder {
        public GetBuilder(HttpRequestBase method) {
            super(method);
        }

        public <X> X execute(final Class<X> cl) throws IOException {
            return this.execute(new ResponseHandler(){

                @Override
                public <X> X handleResponse(StatusLine statusLine, CloseableHttpResponse response) throws IOException {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        return RESTClient.this.jsonParser.parse(entity.getContent(), cl);
                    }
                    return null;
                }
            });
        }

        public ResponseStream executeReturnStream() throws IOException {
            return this.executeReturnStreamInternal();
        }
    }

    public class PostBuilder
    extends AbstractMethodBuilder {
        public PostBuilder(HttpRequestBase method) {
            super(method);
        }

        public <X> X execute(final Class<X> clazz) throws IOException {
            return this.execute(new ResponseHandler(){

                @Override
                public <X> X handleResponse(StatusLine statusLine, CloseableHttpResponse response) throws IOException {
                    return RESTClient.this.jsonParser.parse(response.getEntity().getContent(), clazz);
                }
            });
        }
    }

    public abstract class AbstractMethodBuilder
    implements HttpOperationBuilder {
        protected HttpRequestBase method;

        public AbstractMethodBuilder(HttpRequestBase method) {
            this.method = method;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected <X> X execute(ResponseHandler responseHandler) throws RESTException {
            try (CloseableHttpResponse response = RESTClient.this.httpClient.execute((HttpUriRequest)this.method);){
                StatusLine statusLine = response.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                if (statusCode >= 200 && statusCode <= 299) {
                    Object x = responseHandler.handleResponse(statusLine, response);
                    return x;
                }
                String reasonPhrase = statusLine.getReasonPhrase();
                if (!StringUtils.isBlank((String)reasonPhrase)) throw new RESTException(reasonPhrase, null, statusCode);
                reasonPhrase = "Received HTTP error code: " + statusCode;
                throw new RESTException(reasonPhrase, null, statusCode);
            }
            catch (IOException e) {
                throw new RESTException(e, -1);
            }
        }

        protected ResponseStream executeReturnStreamInternal() throws IOException {
            CloseableHttpResponse response;
            try {
                response = RESTClient.this.httpClient.execute((HttpUriRequest)this.method);
            }
            catch (IOException e) {
                throw new RESTException(e, -1);
            }
            ResponseStream is = null;
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode >= 200 && statusCode <= 299) {
                if (response.getEntity() == null || response.getEntity().getContent() == null) {
                    return null;
                }
            } else {
                IOUtils.close((Closeable[])new Closeable[]{response});
                throw new RESTException(statusLine.getReasonPhrase(), null, statusCode);
            }
            is = new ResponseStream(response);
            return is;
        }
    }

    public static interface ResponseHandler {
        public <X> X handleResponse(StatusLine var1, CloseableHttpResponse var2) throws IOException;
    }

    public static interface HttpOperationBuilder {
    }
}

