/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.provisioning;

import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProvisioningScope {
    private Type type;
    private String scope;

    public ProvisioningScope() {
    }

    public ProvisioningScope(Type type, String scope) {
        this.type = type;
        this.scope = scope;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Set<Environment> matchEnvironments(Collection<Environment> environments) throws NotFoundException {
        Stream<Environment> s = environments.stream();
        switch (this.type) {
            case ENV_ALL: {
                return new HashSet<Environment>(environments);
            }
            case ENV: {
                s = s.filter(e -> this.scope.equals(e.getName()));
                break;
            }
            case ENV_TYPE: {
                s = s.filter(e -> e.getType().equals((Object)Environment.Type.valueOf(this.scope.toUpperCase())));
                break;
            }
            case ENV_RGX: {
                s = s.filter(e -> this.scope.matches(this.scope));
                break;
            }
            case ENV_GROUP: {
                s = s.filter(e -> e.getGroup() != null && e.getGroup().equals(this.scope));
                break;
            }
            case ENV_NONPROD: {
                s = s.filter(e -> !e.getType().equals((Object)Environment.Type.PRODUCTION));
                break;
            }
            default: {
                throw new UnexpectedException("Invalid scope: " + (Object)((Object)this.type));
            }
        }
        return s.collect(Collectors.toSet());
    }

    public String toShortMarkdown() {
        switch (this.type) {
            case ENV: {
                return this.scope;
            }
            case ENV_RGX: {
                return "Regex(" + this.scope + ")";
            }
            case ENV_TYPE: {
                return "Type(" + this.scope + ")";
            }
            case ENV_GROUP: {
                return "Group(" + this.scope + ")";
            }
            case ENV_NONPROD: {
                return "Non-Prod";
            }
            case ENV_ALL: {
                return "*All*";
            }
        }
        return (Object)((Object)this.type) + "(" + this.scope + ")";
    }

    public static enum Type {
        ENV,
        ENV_RGX,
        ENV_TYPE,
        ENV_ALL,
        ENV_GROUP,
        ENV_NONPROD;

    }
}

