/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.config;

import com.aeontronix.enhancedmule.config.ConfigCredentials;
import com.aeontronix.enhancedmule.config.ConfigProfile;
import com.aeontronix.enhancedmule.config.CredentialsBearerTokenImpl;
import com.aeontronix.enhancedmule.tools.cli.EMTCli;
import com.aeontronix.enhancedmule.tools.cli.config.ConfigCmd;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="bearer", description={"Set username/password authentication in configuration"})
public class ConfigSetCredsBearerCmd
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigSetCredsBearerCmd.class);
    @CommandLine.ParentCommand
    private ConfigCmd parent;
    @CommandLine.Parameters(description={"Bearer token"}, arity="1")
    String bearer;

    @Override
    public Integer call() throws Exception {
        EMTCli cli = this.parent.getCli();
        ConfigProfile profile = cli.getActiveProfile();
        profile.setCredentials((ConfigCredentials)new CredentialsBearerTokenImpl(this.bearer));
        cli.saveConfig();
        logger.info("Credentials updated");
        return 0;
    }
}

