/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.crypto;

import com.aeontronix.enhancedmule.tools.cli.crypto.AbstractCryptoCmd;
import com.aeontronix.enhancedmule.tools.cli.crypto.CryptoHelper;
import com.aeontronix.kryptotek.Key;
import java.io.File;
import picocli.CommandLine;

@CommandLine.Command(name="encrypt", description={"Encrypt properties"})
public class EncryptCmd
extends AbstractCryptoCmd {
    @CommandLine.Option(names={"-n", "--no-expression"}, description={"if this flag is used, only the encrypted value will be returned rather than the whole property expression"}, arity="1")
    private boolean noExpression;

    @Override
    public int run(Key key, String value) throws Exception {
        if (value != null) {
            System.out.println(CryptoHelper.encrypt(key, value, this.noExpression));
        } else {
            CryptoHelper.encryptProperties(key, this.path);
        }
        return 0;
    }

    static class KeyOptions {
        @CommandLine.Option(names={"-s", "--key-string"}, description={"Encryption key as text"}, required=true)
        String key;
        @CommandLine.Option(names={"-f", "--key-file"}, description={"Encryption key file"}, required=true)
        File keyFile;

        KeyOptions() {
        }
    }
}

