/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.crypto;

import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.commons.file.FileUtils;
import com.aeontronix.enhancedmule.tools.cli.EMTCli;
import com.aeontronix.kryptotek.CryptoUtils;
import com.aeontronix.kryptotek.EncodedKey;
import com.aeontronix.kryptotek.InvalidKeyEncodingException;
import com.aeontronix.kryptotek.key.AESKeyLen;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="keygen", description={"Generate a property encryption key"})
public class KeyGenCmd
implements Callable<Integer> {
    @CommandLine.ParentCommand
    private EMTCli cli;
    @CommandLine.Parameters(description={"File to write key to"}, arity="0..1")
    private File file;
    @CommandLine.Option(names={"-s", "--save"}, description={"Save key to active profile"}, defaultValue="false")
    private boolean save;

    @Override
    public Integer call() throws Exception {
        String key = KeyGenCmd.genKey(this.file);
        if (key != null) {
            System.out.println(key);
        }
        if (this.save) {
            this.cli.getActiveProfile().setCryptoKey(key);
            this.cli.saveConfig();
        }
        return 0;
    }

    public static String genKey(File file) {
        try {
            EncodedKey encodedKey = CryptoUtils.generateAESKey((AESKeyLen)AESKeyLen.AES256).getEncoded(EncodedKey.Format.B64);
            if (file != null) {
                FileUtils.write((File)file, (byte[])encodedKey.getEncodedKeyData());
                return null;
            }
            return encodedKey.getEncodedKeyString();
        }
        catch (InvalidKeyEncodingException | IOException e) {
            throw new UnexpectedException(e);
        }
    }
}

