/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.role;

import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.RoleDescriptor;
import com.aeontronix.enhancedmule.tools.role.RoleAssignment;
import com.aeontronix.enhancedmule.tools.role.RoleAssignmentAddition;
import com.aeontronix.enhancedmule.tools.role.RoleAssignmentList;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.HttpHelper;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class RoleGroup
extends AnypointObject<Organization> {
    @JsonProperty(value="role_group_id")
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private boolean editable;
    @JsonProperty(value="external_names")
    private Set<String> externalNames;

    public RoleGroup(AnypointClient client) {
        super(client);
    }

    public RoleGroup(Organization parent) {
        super(parent);
    }

    public RoleGroup() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public Set<String> getExternalNames() {
        return this.externalNames;
    }

    public void setExternalNames(Set<String> externalNames) {
        this.externalNames = externalNames;
    }

    public RoleGroup update() throws HttpException {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        if (this.editable) {
            changes.put("name", this.name);
            changes.put("description", this.description);
        }
        changes.put("external_names", this.externalNames);
        String json = this.httpHelper.httpPut(RoleGroup.buildUrlStr((Organization)this.parent, this.id), changes);
        return this.jsonHelper.readJson(new RoleGroup(), json, this.parent);
    }

    public static RoleGroup findById(Organization organization, HttpHelper httpHelper, JsonHelper jsonHelper, String id) throws NotFoundException, HttpException {
        try {
            String buildUrl = RoleGroup.buildUrlStr(organization, id);
            String json = httpHelper.httpGet(buildUrl);
            return jsonHelper.readJson(new RoleGroup(), json, organization);
        }
        catch (HttpException e) {
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Role with id " + id + " not found in org " + organization.getId());
            }
            throw e;
        }
    }

    public RoleAssignmentList findRoleAssignments() throws HttpException, NotFoundException {
        try {
            return new RoleAssignmentList(this);
        }
        catch (HttpException e) {
            if (e.getStatusCode() == 404) {
                throw new NotFoundException(e.getMessage());
            }
            throw e;
        }
    }

    public List<RoleAssignment> assignRoles(Iterable<RoleAssignmentAddition> roleAssignmentAdditions) throws HttpException {
        String json = this.httpHelper.httpPost(RoleGroup.buildUrl((Organization)this.parent, this.id).path("roles").toString(), roleAssignmentAdditions);
        return this.jsonHelper.readJsonList(RoleAssignment.class, json, null);
    }

    public void deleteAllRoleAssignment() throws HttpException {
        try {
            this.deleteRoleAssignment(this.findRoleAssignments());
        }
        catch (NotFoundException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public void deleteRoleAssignment(Iterable<RoleAssignment> roleAssignments) throws HttpException {
        for (RoleAssignment roleAssignment : roleAssignments) {
            this.httpHelper.httpDelete(RoleGroup.buildUrl((Organization)this.parent, this.getId()).path("roles").queryParam("roleId", (Object)roleAssignment.getId()).toString(), Collections.singletonList(roleAssignment));
        }
    }

    private static String buildUrlStr(Organization organization, String id) {
        return RoleGroup.buildUrl(organization, id).toString();
    }

    private static URLBuilder buildUrl(Organization organization, String id) {
        return new URLBuilder("/accounts/api/organizations/").path(organization.getId()).path("rolegroups").path(id);
    }

    public boolean same(RoleDescriptor roleDescriptor) {
        return Objects.equals(roleDescriptor.getDescription(), this.description) && Objects.equals(roleDescriptor.getExternalNames(), this.externalNames);
    }
}

