/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.api;

import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.api.API;
import com.aeontronix.enhancedmule.tools.anypoint.api.APIContract;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.logging.Logger;

public class APIAsset
extends AnypointObject<Environment> {
    private static final Logger logger = Logger.getLogger(APIAsset.class.getName());
    private int id;
    private String masterOrganizationId;
    private String organizationId;
    private String name;
    private String exchangeAssetName;
    private String groupId;
    private String assetId;
    private List<API> apis;

    public APIAsset() {
    }

    public APIAsset(Environment env) {
        super(env);
    }

    @Override
    public void setParent(Environment parent) {
        super.setParent(parent);
        if (this.apis != null) {
            for (API api : this.apis) {
                api.setParent(parent);
            }
        }
    }

    @JsonProperty
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @JsonProperty
    public String getMasterOrganizationId() {
        return this.masterOrganizationId;
    }

    public void setMasterOrganizationId(String masterOrganizationId) {
        this.masterOrganizationId = masterOrganizationId;
    }

    @JsonProperty
    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public String getExchangeAssetName() {
        return this.exchangeAssetName;
    }

    public void setExchangeAssetName(String exchangeAssetName) {
        this.exchangeAssetName = exchangeAssetName;
    }

    @JsonProperty
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @JsonProperty
    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    @JsonProperty
    public List<API> getApis() {
        return this.apis;
    }

    public void setApis(List<API> apis) {
        this.apis = apis;
    }

    public void delete() throws HttpException {
        for (API api : this.apis) {
            for (APIContract contract : api.findContracts()) {
                if (contract.isApproved()) {
                    contract.revokeAccess();
                }
                contract.delete();
            }
            this.httpHelper.httpDelete("/apimanager/api/v1/organizations/" + ((Organization)((Environment)this.parent).getParent()).getId() + "/environments/" + ((Environment)this.parent).getId() + "/apis/" + api.getId());
        }
    }
}

