/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.api;

import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.api.API;
import com.aeontronix.enhancedmule.tools.anypoint.api.SLATierLimits;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SLATier
extends AnypointObject<API> {
    private Long id;
    private String name;
    private String status;
    private String description;
    private boolean autoApprove;
    private int applicationCount;
    private List<SLATierLimits> limits;

    public SLATier(AnypointClient client) {
        super(client);
    }

    public SLATier(API parent) {
        super(parent);
    }

    public SLATier() {
    }

    public static List<String> getNames(List<SLATier> slaTier) {
        ArrayList<String> names = new ArrayList<String>(slaTier.size());
        for (SLATier tier : slaTier) {
            if (tier.getName() == null) continue;
            names.add(tier.getName());
        }
        return names;
    }

    @JsonProperty
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void delete() throws HttpException {
        this.client.getHttpHelper().httpDelete(this.getUrl());
    }

    @NotNull
    private String getUrl() {
        return "/apimanager/api/v1/organizations/" + ((Organization)((Environment)((API)this.parent).getParent()).getParent()).getId() + "/environments/" + ((Environment)((API)this.parent).getParent()).getId() + "/apis/" + ((API)this.parent).getId() + "/tiers/" + this.id;
    }

    @JsonProperty
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty
    public boolean isAutoApprove() {
        return this.autoApprove;
    }

    public void setAutoApprove(boolean autoApprove) {
        this.autoApprove = autoApprove;
    }

    @JsonProperty
    public int getApplicationCount() {
        return this.applicationCount;
    }

    public void setApplicationCount(int applicationCount) {
        this.applicationCount = applicationCount;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty
    public List<SLATierLimits> getLimits() {
        return this.limits;
    }

    public void setLimits(List<SLATierLimits> limits) {
        this.limits = limits;
    }

    public SLATier update() throws HttpException {
        String json = this.client.getHttpHelper().httpPut(this.getUrl(), this);
        return this.client.getJsonHelper().readJson(new SLATier((API)this.parent), json);
    }
}

