/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.provisioning;

import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ProvisioningException;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ProvisioningRequest;
import com.aeontronix.enhancedmule.tools.application.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.APIDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.APIProvisioningResult;
import com.aeontronix.enhancedmule.tools.application.api.ClientApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.MuleAPIProvisioningService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationProvisioningService {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationProvisioningService.class);
    private MuleAPIProvisioningService muleAPIProvisioningService;
    private AnypointClient client;

    public ApplicationProvisioningService(AnypointClient client, MuleAPIProvisioningService muleAPIProvisioningService) {
        this.muleAPIProvisioningService = muleAPIProvisioningService;
    }

    public ApplicationProvisioningService(AnypointClient client) {
        this(client, new MuleAPIProvisioningService(client));
    }

    public APIProvisioningResult provision(ApplicationDescriptor applicationDescriptor, Environment environment, ProvisioningRequest request) throws ProvisioningException {
        try {
            ClientApplicationDescriptor client;
            logger.info("Starting provisioning");
            APIProvisioningResult result = new APIProvisioningResult();
            APIDescriptor api = applicationDescriptor.getApi();
            if (api != null) {
                logger.debug("API descriptor found, provisioning");
                this.muleAPIProvisioningService.provisionAPI(api, applicationDescriptor, environment, result);
            }
            if ((client = applicationDescriptor.getClient()) != null) {
                client.provision(applicationDescriptor, environment, request, result);
            }
            logger.info("Finished provisioning");
            return result;
        }
        catch (Exception e) {
            throw new ProvisioningException(e);
        }
    }
}

