/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.application.template;

import com.aeontronix.commons.file.FileUtils;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="create")
public class ApplicationTemplateCreateCmd
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationTemplateCreateCmd.class);
    @CommandLine.Parameters(description={"Directory where template files will be created"})
    private File directory;

    @Override
    public Integer call() throws Exception {
        if (!this.directory.exists()) {
            FileUtils.mkdirs((File)this.directory);
        }
        ObjectMapper mapper = JsonHelper.createMapper();
        URL resource = this.getClass().getResource("/template/genesis-template.json");
        JsonNode json = mapper.readTree(resource);
        ArrayList<String> files = new ArrayList<String>();
        files.add("genesis-template.json");
        for (JsonNode jsonNode : json.get("files")) {
            JsonNode res = jsonNode.get("resource");
            String filename = JsonHelper.isNotNull(res) ? res.textValue() : jsonNode.get("path").textValue();
            files.add(filename);
        }
        for (String string : files) {
            InputStream is = this.getClass().getResourceAsStream("/template/" + string);
            try (FileOutputStream fw = new FileOutputStream(new File(this.directory, string));){
                IOUtils.copy((InputStream)is, (OutputStream)fw);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        System.out.println("Application template created: " + this.directory.getAbsolutePath());
        return 0;
    }

    private void writeFile(File directory, String name) {
    }
}

