/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.application.template;

import com.aeontronix.commons.ArchiveUtils;
import com.aeontronix.commons.file.TempFile;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.cli.application.template.ApplicationTemplateCmd;
import com.aeontronix.enhancedmule.tools.emclient.EnhancedMuleClient;
import com.aeontronix.enhancedmule.tools.util.FileStreamSource;
import java.io.File;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="publish")
public class ApplicationTemplatePublishCmd
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationTemplatePublishCmd.class);
    public static final String EMT_TEMPLATE_ASSET_ID = "emt-application-template";
    @CommandLine.Option(names={"-d"}, description={"Directory where template files will be created"})
    private File directory;
    @CommandLine.Option(names={"-o"}, description={"Organization used to publish template"})
    private String organization;
    @CommandLine.Option(names={"-i"}, description={"Exchange asset id"})
    private String assetId = "emt-application-template";
    @CommandLine.Option(names={"-n"}, description={"Exchange asset name"})
    private String assetName = "Enhanced Mule Application Template";
    @CommandLine.Option(names={"-v"}, description={"Exchange asset version"})
    private String assetVersion = "0.0.1";
    @CommandLine.ParentCommand
    private ApplicationTemplateCmd parent;

    @Override
    public Integer call() throws Exception {
        if (!this.directory.exists()) {
            logger.error("Directory not found: " + this.directory.getPath());
            return -1;
        }
        try (TempFile tarch = new TempFile("tarch", ".zip");){
            ArchiveUtils.zipDir((String)this.directory.getPath(), (File)tarch);
            EnhancedMuleClient client = this.parent.getParent().getCli().getClient(this.organization, null);
            Organization org = this.parent.getParent().getCli().findOrganization(this.organization);
            org.getClient().findOrganizations();
            org.publishExchangeCustomAsset(this.assetId, this.assetName, this.assetVersion, new FileStreamSource((File)tarch));
        }
        logger.info("Asset published successfully");
        return 0;
    }
}

