/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.application.deploy;

import com.aeontronix.commons.Required;
import com.aeontronix.commons.file.TempFile;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.api.ClientApplication;
import com.aeontronix.enhancedmule.tools.anypoint.application.DeploymentException;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.RuntimeDeploymentRequest;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAssetDescriptor;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ApplicationProvisioningService;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ExchangeManagementClient;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ProvisioningException;
import com.aeontronix.enhancedmule.tools.application.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.APIDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.APIProvisioningResult;
import com.aeontronix.enhancedmule.tools.application.api.ClientApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ExchangeApplicationSource;
import com.aeontronix.enhancedmule.tools.legacy.deploy.FileApplicationSource;
import com.aeontronix.enhancedmule.tools.runtime.DeploymentResult;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.HttpHelper;
import com.aeontronix.unpack.FileType;
import com.aeontronix.unpack.Unpacker;
import com.aeontronix.unpack.transformer.SetPropertyTransformer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeploymentOperation {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentOperation.class);
    private static final EMTLogger elogger = new EMTLogger(logger);
    public static final String ANYPOINT_PLATFORM_CLIENT_ID = "anypoint.platform.client_id";
    public static final String ANYPOINT_PLATFORM_CLIENT_SECRET = "anypoint.platform.client_secret";
    protected RuntimeDeploymentRequest deploymentRequest;
    protected Environment environment;
    protected ApplicationSource source;

    public DeploymentOperation() {
    }

    public DeploymentOperation(RuntimeDeploymentRequest request, Environment environment, ApplicationSource source) {
        this.deploymentRequest = request;
        this.environment = environment;
        this.source = source;
    }

    public DeploymentResult deploy() throws ProvisioningException, IOException, HttpException, DeploymentException {
        DeploymentResult deploymentResult;
        block28: {
            AnypointClient client = this.environment.getClient();
            boolean tmpFile = false;
            try {
                Map<String, String> fileProperties;
                this.environment = this.environment.refresh();
                APIProvisioningResult provisioningResult = null;
                ArrayList<SetPropertyTransformer> transformers = new ArrayList<SetPropertyTransformer>();
                ApplicationDescriptor applicationDescriptor = this.deploymentRequest.getApplicationDescriptor();
                if (applicationDescriptor == null) {
                    logger.info("no anypoint.json found, skipping provisioning");
                }
                if (applicationDescriptor != null && !this.deploymentRequest.isSkipProvisioning()) {
                    boolean bl;
                    ExchangeManagementClient exchangeManagementClient;
                    Organization organization;
                    block27: {
                        logger.debug("Found anypoint provisioning file, provisioning");
                        if (logger.isDebugEnabled()) {
                            logger.debug(client.getJsonHelper().getJsonMapper().writeValueAsString((Object)applicationDescriptor));
                        }
                        organization = this.environment.getOrganization();
                        ApplicationProvisioningService applicationProvisioningService = new ApplicationProvisioningService(client);
                        boolean bl2 = false;
                        exchangeManagementClient = new ExchangeManagementClient();
                        if (applicationDescriptor.isAssetPublish()) {
                            ExchangeAssetDescriptor asset = applicationDescriptor.getApi().getAsset();
                            bl = exchangeManagementClient.publish(asset, organization, this.source, this.deploymentRequest);
                        }
                        provisioningResult = applicationProvisioningService.provision(applicationDescriptor, this.environment, this.deploymentRequest);
                        APIDescriptor apiDescriptor = applicationDescriptor.getApi();
                        if (provisioningResult.getApi() != null && apiDescriptor.isInjectApiId()) {
                            String apiIdProperty = apiDescriptor.getApiIdProperty();
                            if (apiIdProperty == null) {
                                throw new IllegalArgumentException("apiIdProperty musn't be null");
                            }
                            this.deploymentRequest.setOverrideProperty(apiIdProperty, provisioningResult.getApi().getId());
                            this.deploymentRequest.setOverrideProperty(ANYPOINT_PLATFORM_CLIENT_ID, this.environment.getClientId());
                            try {
                                String clientSecret = this.environment.getClientSecret();
                                if (clientSecret != null) {
                                    this.deploymentRequest.setOverrideProperty(ANYPOINT_PLATFORM_CLIENT_SECRET, clientSecret);
                                }
                            }
                            catch (HttpException e) {
                                if (e.getStatusCode() == 401) break block27;
                                throw e;
                            }
                        }
                    }
                    if (bl && this.deploymentRequest.isDeleteSnapshots()) {
                        exchangeManagementClient.deleteSnapshots(organization, applicationDescriptor.getApi().getAsset());
                    }
                    ClientApplicationDescriptor clientDescriptor = applicationDescriptor.getClient();
                    ClientApplication clientApp = provisioningResult.getClientApplication();
                    if (clientApp != null && clientDescriptor != null && clientDescriptor.isInjectClientIdSec()) {
                        String clientIdProperty = clientDescriptor.getClientIdProperty();
                        if (clientIdProperty == null) {
                            throw new IllegalStateException("client descriptor id property musn't be null");
                        }
                        this.deploymentRequest.setOverrideProperty(clientIdProperty, clientApp.getClientId());
                        String clientSecretProperty = clientDescriptor.getClientSecretProperty();
                        if (clientSecretProperty == null) {
                            throw new IllegalStateException("client descriptor id property musn't be null");
                        }
                        this.deploymentRequest.setOverrideProperty(clientSecretProperty, clientApp.getClientSecret());
                    }
                }
                if ((fileProperties = this.deploymentRequest.getFileProperties()) != null && !fileProperties.isEmpty()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("File properties injected into application: {}", fileProperties);
                        for (Map.Entry entry : fileProperties.entrySet()) {
                            logger.debug("> {} = {}", entry.getKey(), entry.getValue());
                        }
                        logger.debug("filePropertiesPath= {}", (Object)this.deploymentRequest.getFilePropertiesPath());
                    }
                    transformers.add(new SetPropertyTransformer(this.deploymentRequest.getFilePropertiesPath(), Required.CREATE, new HashMap<String, String>(fileProperties)));
                    logger.info("Added properties file to application archive");
                }
                if (!transformers.isEmpty()) {
                    try {
                        if (this.source instanceof FileApplicationSource || this.source.getLocalFile() != null) {
                            File oldFile = this.source.getLocalFile();
                            TempFile tempFile = new TempFile("transformed", this.deploymentRequest.getFilename());
                            this.source = new FileApplicationSource(client, (File)tempFile);
                            Unpacker unpacker = new Unpacker(oldFile, FileType.ZIP, (File)tempFile, FileType.ZIP);
                            unpacker.addTransformers(transformers);
                            unpacker.unpack();
                            logger.info("Enhanced application archive");
                        } else if (this.source instanceof ExchangeApplicationSource) {
                            throw new ProvisioningException("Transformations on exchange sources not supported at this (so OnPrem provisioned deployments won't work with exchange sources until this feature is added)");
                        }
                    }
                    catch (Exception e) {
                        throw new ProvisioningException("An error occurred while applying application " + this.deploymentRequest.getAppName() + " transformations: " + e.getMessage(), e);
                    }
                    tmpFile = true;
                }
                deploymentResult = this.doDeploy(this.deploymentRequest);
                if (!tmpFile) break block28;
            }
            catch (NotFoundException e) {
                try {
                    throw new DeploymentException(e);
                }
                catch (Throwable throwable) {
                    if (tmpFile) {
                        IOUtils.close((Object[])new Object[]{(TempFile)this.source.getLocalFile()});
                    }
                    throw throwable;
                }
            }
            IOUtils.close((Object[])new Object[]{(TempFile)this.source.getLocalFile()});
        }
        return deploymentResult;
    }

    protected abstract DeploymentResult doDeploy(RuntimeDeploymentRequest var1) throws IOException, HttpException, DeploymentException;

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public ApplicationSource getSource() {
        return this.source;
    }

    public void setSource(ApplicationSource source) {
        this.source = source;
    }

    protected String executeRequest(long start, HttpHelper.MultiPartRequest multiPartRequest) throws HttpException, IOException {
        String json = multiPartRequest.execute();
        if (logger.isDebugEnabled()) {
            logger.debug("File upload took " + TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start) + " seconds");
        }
        return json;
    }

    public String processAppName(String appName) {
        return appName != null ? appName : this.deploymentRequest.getArtifactId();
    }
}

