/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.editor;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.swing.PlaceholderTextField;
import com.aeontronix.commons.swing.SwingUtils;
import com.aeontronix.enhancedmule.tools.application.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.APIDescriptor;
import com.aeontronix.enhancedmule.tools.editor.ExchangeDescEditor;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.formdev.flatlaf.FlatDarkLaf;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.miginfocom.swing.MigLayout;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDescEditor
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(AppDescEditor.class);
    private ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor();
    private APIDescriptor apiDescriptor = new APIDescriptor();
    private ObjectMapper objectMapper = JsonHelper.createMapper();
    private JComboBox overrides;
    private JButton overridesEditButton;
    private JTabbedPane sections;
    private JPanel appDetails;
    private JLabel idEditLabel;
    private PlaceholderTextField idTextField;
    private JLabel nameLabel;
    private PlaceholderTextField nameTextField;
    private JLabel descLabel;
    private PlaceholderTextField descTextField;
    private JTabbedPane apiTab;
    private JPanel apiDetails;
    private JLabel label6;
    private JCheckBox apiEnabledCheckbox;
    private JLabel label5;
    private PlaceholderTextField apiConsumerUrlTextField;
    private JLabel label4;
    private PlaceholderTextField apiImplementationUrlTextField;
    private JLabel label7;
    private PlaceholderTextField apiLabelTextField;
    private JPanel apiPoliciesPanel;
    private JPanel apiSlaTiersPanel;
    private ExchangeDescEditor apiExchangeTab;
    private JPanel clientTab;
    private JLabel label9;
    private JCheckBox checkBox4;
    private JLabel label3;
    private JTextField textField3;
    private JPanel deployentTab;
    private JPanel propertiesTab;
    private JScrollPane scrollPane1;
    private RSyntaxTextArea jsonTextArea;

    public AppDescEditor() {
        this.initComponents();
        this.jsonTextArea.setSyntaxEditingStyle("text/json");
        this.apiEnabledCheckboxActionPerformed(null);
    }

    public static void main(String[] args) throws UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel((LookAndFeel)new FlatDarkLaf());
        AppDescEditor panel = new AppDescEditor();
        JFrame frame = SwingUtils.createFrame((String)"Enhanced Mule Application", (JPanel)panel, (Preferences)Preferences.userNodeForPackage(AppDescEditor.class), (int)50, (int)50);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private void descriptorChanged(KeyEvent e) {
        this.descriptorChanged();
    }

    private void descriptorChanged() {
        try {
            this.applicationDescriptor.setId(this.getText((JTextField)this.idTextField));
            this.applicationDescriptor.setName(this.getText((JTextField)this.nameTextField));
            this.apiDescriptor.setConsumerUrl(this.getText((JTextField)this.apiConsumerUrlTextField));
            this.apiDescriptor.setImplementationUrl(this.getText((JTextField)this.apiImplementationUrlTextField));
            this.applicationDescriptor.setApi(this.apiEnabledCheckbox.isSelected() ? this.apiDescriptor : null);
            String json = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.applicationDescriptor);
            this.jsonTextArea.setText(json);
        }
        catch (JsonProcessingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nullable
    private String getText(JTextField textField) {
        return StringUtils.isNotBlank((String)textField.getText()) ? textField.getText() : null;
    }

    private void apiEnabledCheckboxActionPerformed(ActionEvent e) {
        boolean enabled = this.apiEnabledCheckbox.isSelected();
        this.applicationDescriptor.setApi(enabled ? this.apiDescriptor : null);
        this.apiTab.setEnabledAt(1, enabled);
        this.apiTab.setEnabledAt(2, enabled);
        this.apiTab.setEnabledAt(3, enabled);
        this.apiImplementationUrlTextField.setEnabled(enabled);
        this.apiConsumerUrlTextField.setEnabled(enabled);
        this.apiLabelTextField.setEnabled(enabled);
        this.descriptorChanged();
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("com.aeontronix.enhancedmule.tools.Bundle");
        this.overrides = new JComboBox();
        this.overridesEditButton = new JButton();
        this.sections = new JTabbedPane();
        this.appDetails = new JPanel();
        this.idEditLabel = new JLabel();
        this.idTextField = new PlaceholderTextField();
        this.nameLabel = new JLabel();
        this.nameTextField = new PlaceholderTextField();
        this.descLabel = new JLabel();
        this.descTextField = new PlaceholderTextField();
        this.apiTab = new JTabbedPane();
        this.apiDetails = new JPanel();
        this.label6 = new JLabel();
        this.apiEnabledCheckbox = new JCheckBox();
        this.label5 = new JLabel();
        this.apiConsumerUrlTextField = new PlaceholderTextField();
        this.label4 = new JLabel();
        this.apiImplementationUrlTextField = new PlaceholderTextField();
        this.label7 = new JLabel();
        this.apiLabelTextField = new PlaceholderTextField();
        this.apiPoliciesPanel = new JPanel();
        this.apiSlaTiersPanel = new JPanel();
        this.apiExchangeTab = new ExchangeDescEditor();
        this.clientTab = new JPanel();
        this.label9 = new JLabel();
        this.checkBox4 = new JCheckBox();
        this.label3 = new JLabel();
        this.textField3 = new JTextField();
        this.deployentTab = new JPanel();
        this.propertiesTab = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.jsonTextArea = new RSyntaxTextArea();
        this.setLayout((LayoutManager)new MigLayout("hidemode 3", "[grow,fill][fill]", "[][grow]"));
        this.add((Component)this.overrides, "cell 0 0");
        this.overridesEditButton.setText(bundle.getString("AppDescEditor.overridesEditButton.text"));
        this.add((Component)this.overridesEditButton, "cell 1 0");
        this.appDetails.setLayout((LayoutManager)new MigLayout("hidemode 3", "[right][grow,fill]", "[][][]"));
        this.idEditLabel.setText(bundle.getString("AppDescEditor.idEditLabel.text"));
        this.appDetails.add((Component)this.idEditLabel, "cell 0 0");
        this.idTextField.setPlaceholder("Inherited from POM");
        this.idTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AppDescEditor.this.descriptorChanged(e);
            }
        });
        this.appDetails.add((Component)this.idTextField, "cell 1 0");
        this.nameLabel.setText(bundle.getString("AppDescEditor.nameLabel.text"));
        this.appDetails.add((Component)this.nameLabel, "cell 0 1");
        this.nameTextField.setPlaceholder("Inherited from POM");
        this.nameTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AppDescEditor.this.descriptorChanged(e);
            }
        });
        this.appDetails.add((Component)this.nameTextField, "cell 1 1");
        this.descLabel.setText(bundle.getString("AppDescEditor.descLabel.text"));
        this.appDetails.add((Component)this.descLabel, "cell 0 2");
        this.descTextField.setPlaceholder("Inherited from POM");
        this.descTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AppDescEditor.this.descriptorChanged(e);
            }
        });
        this.appDetails.add((Component)this.descTextField, "cell 1 2");
        this.sections.addTab(bundle.getString("AppDescEditor.appDetails.tab.title"), this.appDetails);
        this.apiDetails.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][grow,fill]", "[][][][][][][]"));
        this.label6.setText(bundle.getString("AppDescEditor.label6.text"));
        this.apiDetails.add((Component)this.label6, "cell 0 0,alignx right,growx 0");
        this.apiEnabledCheckbox.addActionListener(e -> this.apiEnabledCheckboxActionPerformed(e));
        this.apiDetails.add((Component)this.apiEnabledCheckbox, "cell 1 0");
        this.label5.setText(bundle.getString("AppDescEditor.label5.text"));
        this.apiDetails.add((Component)this.label5, "cell 0 1,alignx right,growx 0");
        this.apiConsumerUrlTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AppDescEditor.this.descriptorChanged(e);
            }
        });
        this.apiDetails.add((Component)this.apiConsumerUrlTextField, "cell 1 1");
        this.label4.setText(bundle.getString("AppDescEditor.label4.text"));
        this.apiDetails.add((Component)this.label4, "cell 0 2,alignx right,growx 0");
        this.apiImplementationUrlTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AppDescEditor.this.descriptorChanged(e);
            }
        });
        this.apiDetails.add((Component)this.apiImplementationUrlTextField, "cell 1 2");
        this.label7.setText(bundle.getString("AppDescEditor.label7.text"));
        this.apiDetails.add((Component)this.label7, "cell 0 3,alignx right,growx 0");
        this.apiLabelTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AppDescEditor.this.descriptorChanged(e);
            }
        });
        this.apiDetails.add((Component)this.apiLabelTextField, "cell 1 3");
        this.apiTab.addTab(bundle.getString("AppDescEditor.apiDetails.tab.title"), this.apiDetails);
        this.apiPoliciesPanel.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill]", "[][][]"));
        this.apiTab.addTab(bundle.getString("AppDescEditor.apiPoliciesPanel.tab.title"), this.apiPoliciesPanel);
        this.apiSlaTiersPanel.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill]", "[][][]"));
        this.apiTab.addTab(bundle.getString("AppDescEditor.apiSlaTiersPanel.tab.title"), this.apiSlaTiersPanel);
        this.apiTab.addTab(bundle.getString("AppDescEditor.apiExchangeTab.tab.title"), this.apiExchangeTab);
        this.sections.addTab(bundle.getString("AppDescEditor.apiTab.tab.title"), this.apiTab);
        this.clientTab.setLayout((LayoutManager)new MigLayout("hidemode 3", "[right][grow,fill]", "[][][]"));
        this.label9.setText(bundle.getString("AppDescEditor.label9.text"));
        this.clientTab.add((Component)this.label9, "cell 0 0");
        this.clientTab.add((Component)this.checkBox4, "cell 1 0");
        this.label3.setText(bundle.getString("AppDescEditor.label3.text"));
        this.clientTab.add((Component)this.label3, "cell 0 1");
        this.clientTab.add((Component)this.textField3, "cell 1 1");
        this.sections.addTab(bundle.getString("AppDescEditor.clientTab.tab.title"), this.clientTab);
        this.deployentTab.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill]", "[][][]"));
        this.sections.addTab(bundle.getString("AppDescEditor.deployentTab.tab.title"), this.deployentTab);
        this.propertiesTab.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill]", "[][][]"));
        this.sections.addTab(bundle.getString("AppDescEditor.propertiesTab.tab.title"), this.propertiesTab);
        this.scrollPane1.setViewportView((Component)this.jsonTextArea);
        this.sections.addTab("JSON", this.scrollPane1);
        this.add((Component)this.sections, "cell 0 1 2 1,dock center");
    }
}

