/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.EnvironmentNotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.alert.Alert;
import com.aeontronix.enhancedmule.tools.anypoint.alert.AlertUpdate;
import com.aeontronix.enhancedmule.tools.anypoint.api.API;
import com.aeontronix.enhancedmule.tools.anypoint.api.APIAsset;
import com.aeontronix.enhancedmule.tools.anypoint.api.APIList;
import com.aeontronix.enhancedmule.tools.anypoint.api.APISpec;
import com.aeontronix.enhancedmule.tools.cloudhub.CHMuleVersion;
import com.aeontronix.enhancedmule.tools.cloudhub.CHRegion;
import com.aeontronix.enhancedmule.tools.cloudhub.CHWorkerType;
import com.aeontronix.enhancedmule.tools.runtime.CHApplication;
import com.aeontronix.enhancedmule.tools.runtime.Server;
import com.aeontronix.enhancedmule.tools.runtime.ServerGroup;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.HttpHelper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.client.methods.HttpRequestBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment
extends AnypointObject<Organization> {
    private static final Logger logger = LoggerFactory.getLogger(Environment.class);
    private String id;
    private String name;
    private boolean production;
    private Type type;
    private String clientId;
    private String group;

    public Environment() {
    }

    public Environment(Organization organization) {
        super(organization);
    }

    public Environment(Organization organization, String id) {
        super(organization);
        this.id = id;
    }

    @JsonIgnore
    public Organization getOrganization() {
        return (Organization)this.parent;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @JsonProperty(value="isProduction")
    public boolean isProduction() {
        return this.production;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() throws HttpException {
        String json = this.httpHelper.httpGet("/accounts/api/organizations/" + ((Organization)this.parent).getId() + "/clients/" + this.clientId);
        try {
            return this.jsonHelper.getJsonMapper().readTree(json).at("/client_secret").textValue();
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    @NotNull
    public String getServerRegistrationKey() throws HttpException {
        String json = this.httpHelper.anypointHttpGet("/hybrid/api/v1/servers/registrationToken", this);
        return (String)this.jsonHelper.toJsonMap(json).get("data");
    }

    public List<Server> findAllServers() throws HttpException {
        String json = this.client.getHttpHelper().anypointHttpGet("/armui/api/v1/servers", this);
        ArrayList<Server> list = new ArrayList<Server>();
        for (JsonNode node : this.jsonHelper.readJsonTree(json).at("/data")) {
            JsonNode type = node.get("type");
            Server s = type.asText().equals("SERVER_GROUP") ? (Server)this.jsonHelper.readJson(new ServerGroup(this), node) : this.jsonHelper.readJson(new Server(this), node);
            list.add(s);
        }
        return list;
    }

    public ServerGroup createServerGroup(String name, String ... serverIds) throws HttpException {
        if (serverIds == null) {
            serverIds = new String[]{};
        }
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("name", name);
        request.put("serverIds", serverIds);
        String json = this.httpHelper.anypointHttpPost("/hybrid/api/v1/serverGroups", request, this);
        return this.jsonHelper.readJson(new ServerGroup(this), json, "/data");
    }

    @NotNull
    public Server findServerByName(@NotNull String name) throws NotFoundException, HttpException {
        for (Server server : this.findAllServers()) {
            if (!name.equals(server.getName())) continue;
            return server;
        }
        throw new NotFoundException("Cannot find server : " + name);
    }

    public void addHeaders(HttpRequestBase method) {
        method.setHeader("X-ANYPNT-ORG-ID", ((Organization)this.parent).getId());
        method.setHeader("X-ANYPNT-ENV-ID", this.id);
    }

    public void delete() throws HttpException {
        for (Server server : this.findAllServers()) {
            server.delete();
        }
        this.httpHelper.httpDelete("/accounts/api/organizations/" + ((Organization)this.parent).getId() + "/environments/" + this.id);
        logger.info("Deleted environment " + this.id + " : " + this.name);
    }

    public Environment rename(String newName) throws HttpException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("id", this.id);
        req.put("name", newName);
        req.put("organizationId", ((Organization)this.parent).getId());
        String json = this.httpHelper.httpPut("/accounts/api/organizations/" + ((Organization)this.parent).getId() + "/environments/" + this.id, req);
        return this.jsonHelper.readJson(new Environment((Organization)this.parent), json);
    }

    public String toString() {
        return "Environment{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", production=" + this.production + ", type='" + (Object)((Object)this.type) + '\'' + ", clientId='" + this.clientId + '\'' + "} " + super.toString();
    }

    public APIList findAllAPIs() throws HttpException {
        return this.findAPIs(null);
    }

    public APIList findAPIs(String filter) throws HttpException {
        return new APIList(this, filter);
    }

    public API findAPIByExchangeAssetNameAndVersion(@NotNull String name, @NotNull String version) throws HttpException, NotFoundException {
        return this.findAPIByExchangeAssetNameAndVersion(name, version, null);
    }

    public API findAPIByExchangeAssetIdOrNameAndVersion(@NotNull String idOrName, @NotNull String version, @Nullable String label) throws HttpException, NotFoundException {
        for (APIAsset asset : this.findAllAPIs()) {
            if (!asset.getAssetId().equalsIgnoreCase(idOrName)) continue;
            for (API api : asset.getApis()) {
                if (!api.getAssetVersion().equalsIgnoreCase(version) || label != null && !label.equalsIgnoreCase(api.getInstanceLabel())) continue;
                return api;
            }
        }
        return this.findAPIByExchangeAssetNameAndVersion(idOrName, version, label);
    }

    public API findAPIByExchangeAssetNameAndVersion(@NotNull String name, @NotNull String version, @Nullable String label) throws HttpException, NotFoundException {
        for (APIAsset asset : this.findAPIs(name)) {
            if (!asset.getExchangeAssetName().equalsIgnoreCase(name)) continue;
            for (API api : asset.getApis()) {
                if (!api.getAssetVersion().equalsIgnoreCase(version) || label != null && !label.equalsIgnoreCase(api.getInstanceLabel())) continue;
                return api;
            }
        }
        throw new NotFoundException("API " + name + " " + version + " not found");
    }

    public API findAPIByExchangeAssetIdOrNameAndProductAPIVersion(@NotNull String name, @NotNull String productAPIVersion, @Nullable String label) throws HttpException, NotFoundException {
        for (APIAsset asset : this.findAllAPIs()) {
            if (!asset.getAssetId().equalsIgnoreCase(name)) continue;
            for (API api : asset.getApis()) {
                if (!api.getProductVersion().equalsIgnoreCase(productAPIVersion) || label != null && !label.equalsIgnoreCase(api.getInstanceLabel())) continue;
                return api;
            }
        }
        return this.findAPIByExchangeAssetNameAndProductAPIVersion(name, productAPIVersion, label);
    }

    public API findAPIByExchangeAssetNameAndProductAPIVersion(@NotNull String name, @NotNull String productAPIVersion, @Nullable String label) throws HttpException, NotFoundException {
        for (APIAsset asset : this.findAllAPIs()) {
            if (!asset.getExchangeAssetName().equalsIgnoreCase(name)) continue;
            for (API api : asset.getApis()) {
                if (!api.getProductVersion().equalsIgnoreCase(productAPIVersion) || label != null && !label.equalsIgnoreCase(api.getInstanceLabel())) continue;
                return api;
            }
        }
        throw new NotFoundException("API " + name + " with product version " + productAPIVersion + " not found");
    }

    public List<API> findAPIsByExchangeAsset(@NotNull String groupId, @NotNull String assetId) throws HttpException, NotFoundException {
        ArrayList<API> apis = new ArrayList<API>();
        for (APIAsset api : this.findAllAPIs()) {
            if (!api.getGroupId().equalsIgnoreCase(groupId) || !api.getAssetId().equalsIgnoreCase(assetId)) continue;
            apis.addAll(api.getApis());
        }
        return apis;
    }

    public API findAPIByExchangeAsset(@NotNull String groupId, @NotNull String assetId, @NotNull String assetVersion) throws HttpException, NotFoundException {
        return this.findAPIByExchangeAsset(groupId, assetId, assetVersion, null);
    }

    public API findAPIByExchangeAsset(@NotNull String groupId, @NotNull String assetId, @NotNull String assetVersion, @Nullable String label) throws HttpException, NotFoundException {
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("groupId missing (null or blank)");
        }
        if (StringUtils.isBlank((String)assetId)) {
            throw new IllegalArgumentException("assetId missing (null or blank)");
        }
        if (StringUtils.isBlank((String)assetVersion)) {
            throw new IllegalArgumentException("assetVersion missing (null or blank)");
        }
        for (APIAsset asset : this.findAllAPIs()) {
            if (!asset.getGroupId().equalsIgnoreCase(groupId) || !asset.getAssetId().equalsIgnoreCase(assetId)) continue;
            for (API api : asset.getApis()) {
                if (!api.getAssetVersion().equalsIgnoreCase(assetVersion) || label != null && !label.equalsIgnoreCase(api.getInstanceLabel())) continue;
                return api;
            }
        }
        throw new NotFoundException("API based on exchange asset not found: groupId=" + groupId + ", assetId=" + assetId + ", assetVersion=" + assetVersion + ", label=" + label);
    }

    public API findAPIById(String id) throws HttpException {
        String json = this.httpHelper.httpGet(new URLBuilder("/apimanager/api/v1/organizations/" + ((Organization)this.getParent()).getId() + "/environments/" + this.getId() + "/apis/").path(id).toString());
        return this.jsonHelper.readJson(new API(this), json);
    }

    public CHApplication findCHApplicationByDomain(String domain) throws HttpException, NotFoundException {
        return CHApplication.find(this, domain);
    }

    public Environment refresh() throws NotFoundException, HttpException {
        return Environment.findEnvironmentById(this.id, this.client, (Organization)this.parent);
    }

    @JsonIgnore
    public String getLName() {
        return this.getName().replace(" ", "_").toLowerCase();
    }

    @JsonIgnore
    public String getSuffix() {
        return "-" + this.getLName();
    }

    public API createAPI(@NotNull APISpec apiSpec, @Nullable String label, Map<String, Object> implementationUrlJson, String consumerUrl) throws HttpException {
        return API.create(this, apiSpec, label, implementationUrlJson, consumerUrl);
    }

    public API createAPI(@NotNull APISpec apiSpec, boolean mule4, @Nullable String implementationUrl, String consumerUrl, @Nullable String label, @NotNull API.Type type) throws HttpException {
        return API.create(this, apiSpec, mule4, implementationUrl, consumerUrl, label, type);
    }

    public static List<Environment> findEnvironmentsByOrg(@NotNull AnypointClient client, @NotNull Organization organization) throws HttpException {
        String json = client.getHttpHelper().httpGet("/accounts/api/organizations/" + organization.getId() + "/environments");
        return client.getJsonHelper().readJsonList(organization.getEnvironmentClass(), json, organization, "/data");
    }

    @NotNull
    public static Environment findEnvironmentByName(@NotNull String name, @NotNull AnypointClient client, @NotNull Organization organization) throws HttpException, EnvironmentNotFoundException {
        logger.debug("Searching for environment named {}", (Object)name);
        for (Environment environment : Environment.findEnvironmentsByOrg(client, organization)) {
            logger.debug("Checking if " + environment.getName() + " is equals to " + name);
            if (!name.equals(environment.getName())) continue;
            logger.debug("Match found, returning env " + environment.getId());
            return environment;
        }
        try {
            List envNames = Environment.findEnvironmentsByOrg(client, organization).stream().map(Environment::getName).collect(Collectors.toList());
            throw new EnvironmentNotFoundException("Environment not found in org  " + organization.getName() + " : " + name + " must be one of: " + envNames);
        }
        catch (Exception e) {
            if (e instanceof EnvironmentNotFoundException) {
                throw e;
            }
            throw new EnvironmentNotFoundException("Environment not found: " + name);
        }
    }

    @NotNull
    public static Environment findEnvironmentById(@NotNull String id, @NotNull AnypointClient client, @NotNull Organization organization) throws HttpException, EnvironmentNotFoundException {
        logger.debug("finding environment by id: {}", (Object)id);
        String json = null;
        String organizationId = organization.getId();
        try {
            HttpHelper httpHelper = client.getHttpHelper();
            json = httpHelper.httpGet("/accounts/api/organizations/" + organizationId + "/environments/" + id);
            return client.getJsonHelper().readJson(organization.createEnvironmentObject(), json, organization);
        }
        catch (HttpException e) {
            int statusCode = e.getStatusCode();
            if (statusCode == 401 || statusCode == 403) {
                for (Environment environment : Environment.findEnvironmentsByOrg(client, organization)) {
                    if (!environment.getId().equalsIgnoreCase(id)) continue;
                    return environment;
                }
                throw new EnvironmentNotFoundException("Environment not found: " + id);
            }
            if (statusCode == 404) {
                throw new EnvironmentNotFoundException("Environment with id " + id + " not found within org " + organizationId);
            }
            throw e;
        }
    }

    public String getNameOrId() {
        return this.name != null ? "(name) " + this.name : "(id) " + this.id;
    }

    public List<CHMuleVersion> findCHMuleVersions() throws HttpException {
        String json = this.client.getHttpHelper().anypointHttpGet("/cloudhub/api/mule-versions", this);
        return this.client.getJsonHelper().readJsonList(CHMuleVersion.class, json, this, "/data");
    }

    public CHMuleVersion findDefaultCHMuleVersion() throws HttpException {
        for (CHMuleVersion version : this.findCHMuleVersions()) {
            if (!version.isDefaultVersion()) continue;
            return version;
        }
        throw new UnexpectedException("No default mule version found");
    }

    public CHMuleVersion findCHMuleVersion(String muleVersion) throws NotFoundException, HttpException {
        for (CHMuleVersion version : this.findCHMuleVersions()) {
            if (!version.getVersion().equalsIgnoreCase(muleVersion)) continue;
            return version;
        }
        throw new NotFoundException("Unable to find mule version " + muleVersion);
    }

    public List<CHRegion> findAllCHRegions() throws HttpException {
        String json = this.client.getHttpHelper().anypointHttpGet("/cloudhub/api/regions", this);
        return this.client.getJsonHelper().readJsonList(CHRegion.class, json, this);
    }

    public CHRegion findDefaultCHRegion() throws HttpException {
        for (CHRegion region : this.findAllCHRegions()) {
            if (!region.isDefaultRegion()) continue;
            return region;
        }
        throw new UnexpectedException("No default mule version found");
    }

    public List<CHWorkerType> findAllWorkerTypes() throws HttpException {
        String json = this.client.getHttpHelper().anypointHttpGet("/cloudhub/api/organization", this);
        return this.client.getJsonHelper().readJsonList(CHWorkerType.class, json, this, "/plan/workerTypes");
    }

    public CHWorkerType findWorkerTypeByName(String name) throws HttpException, NotFoundException {
        for (CHWorkerType workerType : this.findAllWorkerTypes()) {
            if (!workerType.getName().equalsIgnoreCase(name)) continue;
            return workerType;
        }
        throw new NotFoundException("Unable to find worker type in plan: " + name);
    }

    public CHWorkerType findSmallestWorkerType() throws HttpException {
        CHWorkerType smallest = null;
        for (CHWorkerType workerType : this.findAllWorkerTypes()) {
            if (smallest != null && smallest.getWorkerVal().compareTo(workerType.getWorkerVal()) <= 0) continue;
            smallest = workerType;
        }
        return smallest;
    }

    public List<Alert> findAlerts() throws HttpException {
        String json = this.httpHelper.anypointHttpGet("https://anypoint.mulesoft.com/armui/api/v1/alerts", this);
        return this.jsonHelper.readJsonList(Alert.class, json, this, "/data");
    }

    public Alert findAlertByName(String name) throws HttpException, NotFoundException {
        for (Alert alert : this.findAlerts()) {
            if (!alert.getName().equals(name)) continue;
            return alert;
        }
        throw new NotFoundException("Unable to find alert named: " + name);
    }

    public void applyAlert(AlertUpdate alert) throws HttpException {
        URLBuilder url = new URLBuilder("/armui/api/v1/alerts");
        if (alert.getCondition().getResourceType().startsWith("cloudhub-")) {
            url.path("cloudhub");
        } else {
            url.path("hybrid");
        }
        try {
            Alert existingAlert = this.findAlertByName(alert.getName());
            url.path(existingAlert.getId());
            logger.info("Updating existing alert " + existingAlert.getId() + " in env " + this.getNameOrId());
            this.httpHelper.anypointHttpPut(url.toString(), alert, this);
        }
        catch (NotFoundException e) {
            this.httpHelper.anypointHttpPost(url.toString(), alert, this);
        }
    }

    public static Map<String, Environment> toMapIdxByName(Collection<Environment> envs) {
        HashMap<String, Environment> map = new HashMap<String, Environment>();
        for (Environment env : envs) {
            map.put(env.getName(), env);
        }
        return map;
    }

    public static Map<String, Environment> toMapIdxById(Collection<Environment> envs) {
        HashMap<String, Environment> map = new HashMap<String, Environment>();
        for (Environment env : envs) {
            map.put(env.getId(), env);
        }
        return map;
    }

    public static enum Type {
        DESIGN,
        SANDBOX,
        PRODUCTION;

    }
}

