/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.exchange;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetAttribute;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetCategory;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetCreatedBy;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetFile;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetInstance;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetMetadata;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetTag;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetVersion;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.Portal;
import com.aeontronix.enhancedmule.tools.application.api.APICustomField;
import com.aeontronix.enhancedmule.tools.application.api.APICustomFieldDescriptor;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeAsset
extends AnypointObject<Organization> {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeAsset.class);
    @JsonProperty(value="productAPIVersion")
    private String productAPIVersion;
    @JsonProperty(value="runtimeVersion")
    private String runtimeVersion;
    @JsonProperty(value="metadata")
    private AssetMetadata metadata;
    @JsonProperty(value="instances")
    private List<AssetInstance> instances;
    @JsonProperty(value="modifiedAt")
    private String modifiedAt;
    @JsonProperty(value="groupId")
    private String groupId;
    @JsonProperty(value="rating")
    private Integer rating;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="createdAt")
    private String createdAt;
    @JsonProperty(value="generated")
    private List generated;
    @JsonProperty(value="assetId")
    private String assetId;
    @JsonProperty(value="versionGroup")
    private String versionGroup;
    @JsonProperty(value="permissions")
    private List<String> permissions;
    @JsonProperty(value="isPublic")
    private Boolean isPublic;
    @JsonProperty(value="categories")
    private List<AssetCategory> categories;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="assetLink")
    private String assetLink;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="labels")
    private List<String> labels;
    @JsonProperty(value="tags")
    private List<AssetTag> tags;
    @JsonProperty(value="dependencies")
    private List dependencies;
    @JsonProperty(value="createdBy")
    private AssetCreatedBy createdBy;
    @JsonProperty(value="versions")
    private List<AssetVersion> versions;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="files")
    private List<AssetFile> files;
    @JsonProperty(value="attributes")
    private List<AssetAttribute> attributes;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="numberOfRates")
    private Integer numberOfRates;
    @JsonProperty(value="icon")
    private String icon;
    @JsonProperty(value="customFields")
    private List<APICustomField> customFields;

    public ExchangeAsset() {
    }

    public ExchangeAsset(Organization organization) {
        super(organization);
    }

    public AssetInstance findInstances(@Nullable String name, String envId) throws NotFoundException {
        if (this.instances != null) {
            List ilist;
            boolean namedInstance;
            for (AssetInstance instance : this.instances) {
                instance.setParent(this);
            }
            Stream<AssetInstance> s = this.instances.stream().filter(i -> i.getEnvironmentId() != null && i.getEnvironmentId().equalsIgnoreCase(envId));
            boolean bl = namedInstance = !StringUtils.isEmpty((String)name);
            if (namedInstance) {
                s = s.filter(i -> i.getName().equalsIgnoreCase(name));
            }
            if ((ilist = s.collect(Collectors.toList())).size() == 0) {
                throw new NotFoundException("Can't find asset " + name + " in env " + envId);
            }
            if (ilist.size() > 1) {
                if (namedInstance) {
                    throw new NotFoundException("Found more than one instance for api " + this.groupId + ":" + this.assetId + " while searching for instance " + name + ". This is very unexpected as there shouldn't be instances with the same name");
                }
                List instanceNames = this.instances.stream().map(AssetInstance::getName).collect(Collectors.toList());
                throw new NotFoundException("Found more than one instance for api " + this.groupId + ":" + this.assetId + ", please specify instance label: " + instanceNames);
            }
            return (AssetInstance)ilist.iterator().next();
        }
        throw new NotFoundException("Can't find asset " + name + " in env " + envId);
    }

    public String getPage(String name) throws HttpException, NotFoundException {
        try {
            return this.httpHelper.httpGet(new URLBuilder(this.getUrl()).path("/pages/").path(name, true).toString(), Collections.singletonMap("Accept", "text/markdown"));
        }
        catch (HttpException e) {
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Page not found: " + name);
            }
            throw e;
        }
    }

    public Portal getPortal() throws HttpException {
        String json = this.httpHelper.httpGet(this.getUrl() + "/portal");
        return this.jsonHelper.readJson(new Portal(), json);
    }

    public ExchangeAsset updateLabels(List<String> exchangeTags) throws HttpException {
        this.httpHelper.httpPut(this.getUrl() + "/tags", exchangeTags.stream().map(t -> Collections.singletonMap("value", t)).collect(Collectors.toList()));
        try {
            return ((Organization)this.getParent()).findExchangeAsset(this.groupId, this.assetId);
        }
        catch (NotFoundException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public void updatePage(String name, String content) throws HttpException {
        this.httpHelper.httpPut(new URLBuilder(this.getUrl()).path("draft/pages").path(name, true).toString(), Collections.singletonMap("Content-Type", "text/markdown"), content);
        this.httpHelper.httpPatch(this.getUrl(), null);
    }

    public void deleteCategory(String key) throws HttpException {
        this.httpHelper.httpDelete(new URLBuilder(this.getUrl()).path("tags/categories").path(key, true).toString());
    }

    public void updateName(String name) throws HttpException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("name", name);
        this.httpHelper.httpPatch("/exchange/api/v2/assets/" + ((Organization)this.getParent()).getId() + "/" + this.assetId, req);
    }

    public void updateDescription(String description) throws HttpException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("description", description);
        this.httpHelper.httpPatch("/exchange/api/v2/assets/" + ((Organization)this.getParent()).getId() + "/" + this.assetId, req);
    }

    public void updateCategory(String key, List<String> catValues) throws HttpException {
        this.httpHelper.httpPut(new URLBuilder(this.getUrl()).path("tags/categories").path(key, true).toString(), Collections.singletonMap("tagValue", catValues));
    }

    public CustomFieldUpdateResults updateCustomFields(List<APICustomFieldDescriptor> fields) throws HttpException {
        CustomFieldUpdateResults results = new CustomFieldUpdateResults();
        if (fields != null) {
            ArrayList<APICustomFieldDescriptor> definedFields = new ArrayList<APICustomFieldDescriptor>(fields);
            HashMap presentFields = this.customFields != null ? this.customFields.stream().collect(Collectors.toMap(APICustomField::getKey, new Function<APICustomField, Object>(){

                @Override
                public Object apply(APICustomField f) {
                    return f.getValue();
                }
            })) : new HashMap();
            for (APICustomFieldDescriptor f : definedFields) {
                String key = f.getKey();
                Object v = presentFields.remove(key);
                if (v != null && v.equals(f.getValue())) continue;
                try {
                    this.httpHelper.httpPut(new URLBuilder(this.getUrl()).path("tags/fields").path(key, true).toString(), new TagValueWrapper(f.getValue()));
                    results.modified.add(key);
                    logger.debug("Updated field {} to {}", (Object)key, (Object)f.getValue().toString());
                }
                catch (HttpException e) {
                    if (e.getStatusCode() == 404 && !f.isRequired()) {
                        results.notDefined.add(key);
                        logger.debug("Unable to set custom field as it's not defined: " + key);
                        continue;
                    }
                    throw e;
                }
            }
            if (!presentFields.isEmpty()) {
                for (String key : presentFields.keySet()) {
                    this.httpHelper.httpDelete(new URLBuilder(this.getUrl()).path("tags/fields").path(key).toString());
                    results.modified.add(key);
                }
            }
        }
        return results;
    }

    @NotNull
    private String getUrl() {
        return "/exchange/api/v1/organizations/" + ((Organization)this.getParent()).getId() + "/assets/" + this.groupId + "/" + this.assetId + "/" + this.version;
    }

    public String getProductAPIVersion() {
        return this.productAPIVersion;
    }

    public void setProductAPIVersion(String productAPIVersion) {
        this.productAPIVersion = productAPIVersion;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public AssetMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(AssetMetadata metadata) {
        this.metadata = metadata;
    }

    public List<AssetInstance> getInstances() {
        return this.instances;
    }

    public void setInstances(List<AssetInstance> instances) {
        this.instances = instances;
    }

    public String getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(String modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Integer getRating() {
        return this.rating;
    }

    public void setRating(Integer rating) {
        this.rating = rating;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public List getGenerated() {
        return this.generated;
    }

    public void setGenerated(List generated) {
        this.generated = generated;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getVersionGroup() {
        return this.versionGroup;
    }

    public void setVersionGroup(String versionGroup) {
        this.versionGroup = versionGroup;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public Boolean getPublic() {
        return this.isPublic;
    }

    public void setPublic(Boolean aPublic) {
        this.isPublic = aPublic;
    }

    public List<AssetCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(List<AssetCategory> categories) {
        this.categories = categories;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAssetLink() {
        return this.assetLink;
    }

    public void setAssetLink(String assetLink) {
        this.assetLink = assetLink;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public List<AssetTag> getTags() {
        return this.tags;
    }

    public void setTags(List<AssetTag> tags) {
        this.tags = tags;
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List dependencies) {
        this.dependencies = dependencies;
    }

    public AssetCreatedBy getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(AssetCreatedBy createdBy) {
        this.createdBy = createdBy;
    }

    @NotNull
    public List<AssetVersion> getVersions() {
        return this.versions != null ? this.versions : Collections.emptyList();
    }

    public void setVersions(List<AssetVersion> versions) {
        this.versions = versions;
        if (versions != null) {
            for (AssetVersion assetVersion : versions) {
                assetVersion.setParent(this);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<AssetFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<AssetFile> files) {
        this.files = files;
    }

    public List<AssetAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<AssetAttribute> attributes) {
        this.attributes = attributes;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getNumberOfRates() {
        return this.numberOfRates;
    }

    public void setNumberOfRates(Integer numberOfRates) {
        this.numberOfRates = numberOfRates;
    }

    public List<APICustomField> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(List<APICustomField> customFields) {
        this.customFields = customFields;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @JsonIgnore
    public byte[] getIconImage() throws HttpException {
        if (this.icon != null) {
            return this.httpHelper.httpGetBinary(this.icon);
        }
        return null;
    }

    public void updateIcon(byte[] data, String mimeType) throws HttpException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", mimeType);
        this.httpHelper.httpPut(this.getExchangeAssetUrl().path("icon").toString(), headers, data);
    }

    public void deleteVersion(String version) throws HttpException {
        this.httpHelper.httpHardDelete(this.getExchangeAssetUrl().path(version, true).toString());
    }

    private URLBuilder getExchangeAssetUrl() {
        return new URLBuilder("/exchange/api/v2/assets/").path(((Organization)this.getParent()).getId(), true).path(this.assetId, true);
    }

    public class CustomFieldUpdateResults {
        List<String> modified = new ArrayList<String>();
        List<String> notDefined = new ArrayList<String>();

        public List<String> getModified() {
            return this.modified;
        }

        public List<String> getNotDefined() {
            return this.notDefined;
        }
    }

    public static class TagValueWrapper {
        @JsonProperty
        private Object tagValue;

        public TagValueWrapper() {
        }

        public TagValueWrapper(Object tagValue) {
            this.tagValue = tagValue;
        }

        public Object getTagValue() {
            return this.tagValue;
        }

        public void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }
    }
}

