/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.application;

import com.aeontronix.enhancedmule.tools.application.api.APIDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.ClientApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.deployment.DeploymentParameters;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationDescriptor.class);
    private String id;
    private String name;
    private String description;
    private String version;
    private Boolean mule3;
    private APIDescriptor api;
    private ClientApplicationDescriptor client;
    private DeploymentParameters deploymentParams;

    public static File findAnypointFile(File basedir) {
        File file = new File(basedir, "anypoint.yml");
        if (file.exists()) {
            return file;
        }
        file = new File(basedir, "anypoint.yaml");
        if (file.exists()) {
            return file;
        }
        file = new File(basedir, "anypoint.json");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static ApplicationDescriptor createDefault() {
        ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor();
        applicationDescriptor.setDeploymentParams(DeploymentParameters.createDefault());
        return applicationDescriptor;
    }

    public static JsonNode createDefault(ObjectMapper objectMapper) {
        return objectMapper.valueToTree((Object)ApplicationDescriptor.createDefault());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getMule3() {
        return this.mule3;
    }

    public void setMule3(Boolean mule3) {
        this.mule3 = mule3;
    }

    public APIDescriptor getApi() {
        return this.api;
    }

    public void setApi(APIDescriptor api) {
        this.api = api;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ClientApplicationDescriptor getClient() {
        return this.client;
    }

    public void setClient(ClientApplicationDescriptor client) {
        this.client = client;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotNull
    public DeploymentParameters getDeploymentParams() {
        if (this.deploymentParams == null) {
            this.deploymentParams = new DeploymentParameters();
        }
        return this.deploymentParams;
    }

    public void setDeploymentParams(DeploymentParameters deploymentParams) {
        this.deploymentParams = deploymentParams;
    }

    @JsonIgnore
    public boolean isAssetPublish() {
        if (this.api != null && this.api.getAsset() != null) {
            Boolean create = this.api.getAsset().getCreate();
            return create != null && create != false;
        }
        return false;
    }
}

